/*
 * Decompiled with CFR 0.152.
 */
package com.github.hoary.javaav;

import com.github.hoary.javaav.AudioFormat;
import com.github.hoary.javaav.MediaFrame;
import com.googlecode.javacpp.BytePointer;
import com.googlecode.javacpp.Pointer;
import com.googlecode.javacpp.PointerPointer;
import com.googlecode.javacv.cpp.avutil;

public class AudioFrame
extends MediaFrame {
    private AudioFormat format;
    private PointerPointer samplePointer;
    private BytePointer[] planePointers;
    private int samples;

    public AudioFrame(AudioFormat format, int samples) {
        int channels = format.getChannels();
        int sampleFormat = format.getSampleFormat().value();
        int planes = avutil.av_sample_fmt_is_planar((int)sampleFormat) != 0 ? channels : 1;
        int planeLength = samples * channels * avutil.av_get_bytes_per_sample((int)sampleFormat) / planes;
        this.format = format;
        this.samples = samples;
        this.planePointers = new BytePointer[planes];
        this.samplePointer = new PointerPointer(planes);
        for (int i = 0; i < planes; ++i) {
            this.planePointers[i] = new BytePointer(avutil.av_malloc((long)planeLength)).capacity(planeLength);
            this.planePointers[i].limit(planeLength);
            this.samplePointer.put(i, (Pointer)this.planePointers[i]);
        }
    }

    public AudioFormat getAudioFormat() {
        return this.format;
    }

    public PointerPointer getData() {
        return this.samplePointer;
    }

    public int getBufferSize() {
        return this.planePointers[0].capacity();
    }

    public BytePointer[] getPlanes() {
        return this.planePointers;
    }

    public BytePointer getPlane(int index) {
        return this.planePointers[index];
    }

    public int getPlaneCount() {
        return this.planePointers.length;
    }

    public void setSampleCount(int samples) {
        this.samples = samples;
    }

    public int getSampleCount() {
        return this.samples;
    }

    public MediaFrame.Type getType() {
        return MediaFrame.Type.AUDIO;
    }

    public boolean hasFrame() {
        return this.planePointers != null && this.planePointers.length > 0;
    }

    public void clear() {
        if (this.planePointers != null) {
            for (int i = 0; i < this.getPlaneCount(); ++i) {
                avutil.av_free((Pointer)this.planePointers[i].position(0));
            }
            this.planePointers = null;
        }
    }
}

