/*
 * Decompiled with CFR 0.152.
 */
package com.github.hoary.javaav;

import com.github.hoary.javaav.ChannelLayout;
import com.github.hoary.javaav.CodecCapability;
import com.github.hoary.javaav.CodecID;
import com.github.hoary.javaav.JavaAV;
import com.github.hoary.javaav.JavaAVException;
import com.github.hoary.javaav.MediaType;
import com.github.hoary.javaav.PixelFormat;
import com.github.hoary.javaav.SampleFormat;
import com.googlecode.javacpp.IntPointer;
import com.googlecode.javacpp.LongPointer;
import com.googlecode.javacv.cpp.avcodec;
import com.googlecode.javacv.cpp.avutil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.TreeSet;

public class Codec {
    private avcodec.AVCodec avCodec;
    private avcodec.AVCodecContext avContext;

    private Codec() {
    }

    int open(avutil.AVDictionary avDictionary) throws JavaAVException {
        avcodec.AVCodecContext avContext = avcodec.avcodec_alloc_context3((avcodec.AVCodec)this.avCodec);
        return this.open(avDictionary, avContext);
    }

    int open(avutil.AVDictionary avDictionary, avcodec.AVCodecContext avContext) throws JavaAVException {
        if (avContext == null) {
            throw new JavaAVException("Could not open codec. Codec context is null.");
        }
        this.avContext = avContext;
        return avcodec.avcodec_open2((avcodec.AVCodecContext)avContext, (avcodec.AVCodec)this.avCodec, (avutil.AVDictionary)avDictionary);
    }

    avcodec.AVCodecContext getContext() {
        return this.avContext;
    }

    avcodec.AVCodec getCodec() {
        return this.avCodec;
    }

    public static Codec getEncoderById(CodecID codecId) throws JavaAVException {
        if (codecId == null) {
            throw new NullPointerException("CodecID is null.");
        }
        avcodec.AVCodec avCodec = avcodec.avcodec_find_encoder((int)codecId.value());
        if (avCodec == null || avCodec.isNull()) {
            throw new JavaAVException("Encoder not found: " + codecId.toString());
        }
        Codec codec = new Codec();
        codec.avCodec = avCodec;
        return codec;
    }

    public static Codec getDecoderById(CodecID codecId) throws JavaAVException {
        if (codecId == null) {
            throw new NullPointerException("CodecID is null.");
        }
        avcodec.AVCodec avCodec = avcodec.avcodec_find_decoder((int)codecId.value());
        if (avCodec == null || avCodec.isNull()) {
            throw new JavaAVException("Decoder not found: " + codecId.toString());
        }
        Codec codec = new Codec();
        codec.avCodec = avCodec;
        return codec;
    }

    public static Codec getEncoderByName(String avCodecName) throws JavaAVException {
        if (avCodecName == null || avCodecName.isEmpty()) {
            throw new NullPointerException("Codec name is null or empty.");
        }
        avcodec.AVCodec avCodec = avcodec.avcodec_find_encoder_by_name((String)avCodecName);
        if (avCodec == null || avCodec.isNull()) {
            throw new JavaAVException("Encoder not found: " + avCodecName);
        }
        Codec codec = new Codec();
        codec.avCodec = avCodec;
        return codec;
    }

    public static Codec getDecoderByName(String avCodecName) throws JavaAVException {
        if (avCodecName == null || avCodecName.isEmpty()) {
            throw new NullPointerException("Codec name is null or empty.");
        }
        avcodec.AVCodec avCodec = avcodec.avcodec_find_decoder_by_name((String)avCodecName);
        if (avCodec == null || avCodec.isNull()) {
            throw new JavaAVException("Decoder not found: " + avCodecName);
        }
        Codec codec = new Codec();
        codec.avCodec = avCodec;
        return codec;
    }

    public static String[] getInstalledCodecs() {
        TreeSet<String> names = new TreeSet<String>();
        avcodec.AVCodec codec = null;
        while ((codec = avcodec.av_codec_next(codec)) != null) {
            String shortName = codec.name().getString();
            String type = MediaType.byId(codec.type()).toString().substring(0, 1);
            String longName = codec.long_name().getString();
            names.add(String.format("%-17s [%s] %s", shortName, type, longName));
        }
        return names.toArray(new String[0]);
    }

    public String getName() {
        if (this.avCodec == null) {
            return null;
        }
        return this.avCodec.name().getString();
    }

    public String getNameLong() {
        if (this.avCodec == null) {
            return null;
        }
        return this.avCodec.long_name().getString();
    }

    public CodecID getID() {
        if (this.avCodec.isNull()) {
            return null;
        }
        return CodecID.byId(this.avCodec.id());
    }

    public MediaType getType() {
        if (this.avCodec.isNull()) {
            return null;
        }
        return MediaType.byId(this.avCodec.type());
    }

    public boolean canDecode() {
        if (this.avCodec.isNull()) {
            return false;
        }
        return avcodec.av_codec_is_decoder((avcodec.AVCodec)this.avCodec) != 0;
    }

    public boolean canEncode() {
        if (this.avCodec.isNull()) {
            return false;
        }
        return avcodec.av_codec_is_encoder((avcodec.AVCodec)this.avCodec) != 0;
    }

    public int getCapabilities() {
        return this.avCodec.capabilities();
    }

    public boolean hasCapability(CodecCapability flag) {
        if (this.avCodec.isNull()) {
            return false;
        }
        return (this.avCodec.capabilities() & flag.value()) != 0;
    }

    public SampleFormat[] getSupportedSampleFormats() {
        int format;
        IntPointer sampleFormatsPointer = this.avCodec.sample_fmts();
        if (this.getType() != MediaType.AUDIO || sampleFormatsPointer == null) {
            return null;
        }
        ArrayList<SampleFormat> sampleFormats = new ArrayList<SampleFormat>();
        int index = 0;
        while ((format = sampleFormatsPointer.get(index++)) != -1) {
            sampleFormats.add(SampleFormat.byId(format));
        }
        return sampleFormats.toArray(new SampleFormat[0]);
    }

    public Integer[] getSupportedSampleRates() {
        int sampleRate;
        IntPointer sampleRatesPointer = this.avCodec.supported_samplerates();
        if (this.getType() != MediaType.AUDIO || sampleRatesPointer == null) {
            return null;
        }
        ArrayList<Integer> sampleRates = new ArrayList<Integer>();
        int index = 0;
        while ((sampleRate = sampleRatesPointer.get(index++)) != 0) {
            sampleRates.add(sampleRate);
        }
        Collections.sort(sampleRates);
        return sampleRates.toArray(new Integer[0]);
    }

    public Integer[] getSupportedFrameRates() {
        avutil.AVRational frameRate;
        avutil.AVRational frameRates = this.avCodec.supported_framerates();
        if (this.getType() != MediaType.VIDEO || frameRates == null) {
            return null;
        }
        ArrayList<Integer> rates = new ArrayList<Integer>();
        int index = 0;
        while ((frameRate = frameRates.position(index++)) != null) {
            rates.add((int)avutil.av_q2d((avutil.AVRational)frameRate));
        }
        Collections.sort(rates);
        return rates.toArray(new Integer[0]);
    }

    public ChannelLayout[] getSupportedChannelLayouts() {
        long layout;
        LongPointer layoutsPointer = this.avCodec.channel_layouts();
        if (this.getType() != MediaType.AUDIO || layoutsPointer == null) {
            return null;
        }
        ArrayList<ChannelLayout> layouts = new ArrayList<ChannelLayout>();
        int index = 0;
        while ((layout = layoutsPointer.get(index++)) != 0L) {
            layouts.add(ChannelLayout.byId(layout));
        }
        return layouts.toArray(new ChannelLayout[0]);
    }

    public PixelFormat[] getSupportedPixelFormats() {
        int format;
        IntPointer formatsPointer = this.avCodec.pix_fmts();
        if (this.getType() != MediaType.VIDEO || formatsPointer == null) {
            return null;
        }
        ArrayList<PixelFormat> pixelFormats = new ArrayList<PixelFormat>();
        int index = 0;
        while ((format = formatsPointer.get(index++)) != -1) {
            pixelFormats.add(PixelFormat.byId(format));
        }
        Collections.sort(pixelFormats);
        return pixelFormats.toArray(new PixelFormat[0]);
    }

    static {
        JavaAV.loadLibrary();
    }
}

