/*
 * Decompiled with CFR 0.152.
 */
package com.github.hoary.javaav;

import com.github.hoary.javaav.AudioFormat;
import com.github.hoary.javaav.AudioFrame;
import com.github.hoary.javaav.ChannelLayout;
import com.github.hoary.javaav.Codec;
import com.github.hoary.javaav.CodecID;
import com.github.hoary.javaav.Coder;
import com.github.hoary.javaav.JavaAVException;
import com.github.hoary.javaav.MediaPacket;
import com.github.hoary.javaav.MediaType;
import com.github.hoary.javaav.PictureFormat;
import com.github.hoary.javaav.PictureResampler;
import com.github.hoary.javaav.PixelFormat;
import com.github.hoary.javaav.SampleFormat;
import com.github.hoary.javaav.VideoFrame;
import com.googlecode.javacpp.BytePointer;
import com.googlecode.javacpp.Pointer;
import com.googlecode.javacv.cpp.avcodec;
import com.googlecode.javacv.cpp.avutil;
import java.nio.ByteBuffer;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Decoder
extends Coder {
    private PixelFormat pixelFormat = PixelFormat.BGR24;
    private PictureResampler videoResampler;
    private PictureFormat srcPictureFormat;
    private PictureFormat dstPictureFormat;
    private avcodec.AVPicture picture;

    public Decoder(CodecID codecId) throws JavaAVException {
        this(codecId, null);
    }

    Decoder(CodecID codecId, avcodec.AVCodecContext avContext) throws JavaAVException {
        super(Codec.getDecoderById(codecId), avContext);
    }

    @Override
    public void open(Map<String, String> options) throws JavaAVException {
        super.open(options);
        if (this.codec.getType() == MediaType.VIDEO) {
            this.srcPictureFormat = new PictureFormat(this.avContext.width(), this.avContext.height(), PixelFormat.byId(this.avContext.pix_fmt()));
            this.dstPictureFormat = new PictureFormat(this.avContext.width(), this.avContext.height(), this.pixelFormat);
        }
        if (this.codec.canDecode() && this.avContext.time_base().num() > 1000 && this.avContext.time_base().den() == 1) {
            this.avContext.time_base().den(1000);
        }
    }

    @Override
    public void close() {
        if (this.picture != null) {
            avcodec.avpicture_free((avcodec.AVPicture)this.picture);
            this.picture = null;
        }
        if (this.videoResampler != null) {
            this.videoResampler.close();
            this.videoResampler = null;
        }
        super.close();
    }

    @Override
    public int getImageWidth() {
        return this.avContext.width();
    }

    @Override
    public int getImageHeight() {
        return this.avContext.height();
    }

    @Override
    public int getAudioChannels() {
        return this.avContext.channels();
    }

    @Override
    public int getSampleRate() {
        return this.avContext.sample_rate();
    }

    @Override
    public SampleFormat getSampleFormat() {
        return SampleFormat.byId(this.avContext.sample_fmt());
    }

    @Override
    public PixelFormat getPixelFormat() {
        return PixelFormat.byId(this.avContext.pix_fmt());
    }

    @Override
    public void setPixelFormat(PixelFormat format) {
        if (format == null) {
            return;
        }
        this.pixelFormat = format;
    }

    public AudioFrame decodeAudio(MediaPacket mediaPacket) throws JavaAVException {
        if (this.state != Coder.State.Opened) {
            throw new JavaAVException("Could not decode audio, decoder is not opened.");
        }
        if (this.codec.getType() != MediaType.AUDIO) {
            throw new JavaAVException("Could not decode audio, this is a non-audio decoder.");
        }
        if (mediaPacket == null) {
            throw new JavaAVException("No audio passed to decode.");
        }
        AudioFrame frame = null;
        ByteBuffer packetData = mediaPacket.getData();
        if (packetData != null) {
            this.avPacket.data(new BytePointer(packetData));
            this.avPacket.size(packetData.limit());
        } else {
            this.avPacket.data(null);
            this.avPacket.size(0);
        }
        while (this.avPacket.size() > 0) {
            avcodec.avcodec_get_frame_defaults((avutil.AVFrame)this.avFrame);
            int len = avcodec.avcodec_decode_audio4((avcodec.AVCodecContext)this.avContext, (avutil.AVFrame)this.avFrame, (int[])this.gotFrame, (avcodec.AVPacket)this.avPacket);
            if (len > 0) {
                this.avPacket.data(this.avPacket.data().position(len));
                this.avPacket.size(this.avPacket.size() - len);
            }
            if (len <= 0 || this.gotFrame[0] == 0) break;
            avutil.AVRational time_base = this.avContext.time_base();
            long pts = avutil.av_frame_get_best_effort_timestamp((avutil.AVFrame)this.avFrame);
            long timestamp = 1000000L * pts * (long)time_base.num() / (long)time_base.den();
            int sampleFormat = this.avFrame.format();
            int isPlanar = avutil.av_sample_fmt_is_planar((int)sampleFormat);
            int planes = isPlanar != 0 ? this.avFrame.channels() : 1;
            int bufferSize = avutil.av_samples_get_buffer_size((int[])null, (int)this.avContext.channels(), (int)this.avFrame.nb_samples(), (int)this.avContext.sample_fmt(), (int)1) / planes;
            SampleFormat format = SampleFormat.byId(sampleFormat);
            ChannelLayout channelLayout = ChannelLayout.byId(this.avFrame.channel_layout());
            AudioFormat audioFormat = new AudioFormat(format, channelLayout, this.avFrame.channels(), this.avFrame.sample_rate());
            frame = new AudioFrame(audioFormat, this.avFrame.nb_samples());
            frame.setKeyFrame(this.avFrame.key_frame() != 0);
            frame.setTimestamp(timestamp);
            for (int i = 0; i < planes; ++i) {
                BytePointer pointer = this.avFrame.data(i).capacity(bufferSize);
                ByteBuffer buffer = pointer.asBuffer();
                buffer.position(0);
                frame.getPlane(i).asByteBuffer().put(buffer);
            }
        }
        avcodec.av_free_packet((avcodec.AVPacket)this.avPacket);
        return frame;
    }

    public VideoFrame decodeVideo(MediaPacket mediaPacket) throws JavaAVException {
        if (this.state != Coder.State.Opened) {
            throw new JavaAVException("Could not decode video, decoder is not opened.");
        }
        if (this.codec.getType() != MediaType.VIDEO) {
            throw new JavaAVException("Could not decode video, this is a non-video decoder.");
        }
        if (mediaPacket == null) {
            throw new JavaAVException("No data passed to decode.");
        }
        VideoFrame frame = new VideoFrame();
        avcodec.AVPacket mPacket = mediaPacket.getAVPacket();
        if (mPacket != null) {
            avcodec.av_copy_packet((avcodec.AVPacket)this.avPacket, (avcodec.AVPacket)mPacket);
        } else {
            ByteBuffer packetData = mediaPacket.getData();
            if (packetData != null && packetData.limit() > 0) {
                this.avPacket.data(new BytePointer(packetData));
                this.avPacket.size(packetData.limit());
            }
        }
        avcodec.avcodec_get_frame_defaults((avutil.AVFrame)this.avFrame);
        int len = avcodec.avcodec_decode_video2((avcodec.AVCodecContext)this.avContext, (avutil.AVFrame)this.avFrame, (int[])this.gotFrame, (avcodec.AVPacket)this.avPacket);
        if (len >= 0 && this.gotFrame[0] != 0) {
            BytePointer data;
            int channels;
            long pts = avutil.av_frame_get_best_effort_timestamp((avutil.AVFrame)this.avFrame);
            avutil.AVRational time_base = this.avContext.time_base();
            long timestamp = 1000000L * pts * (long)time_base.num() / (long)time_base.den() * 2L;
            int width = this.avContext.width();
            int height = this.avContext.height();
            if (this.videoResampler == null) {
                if (!this.srcPictureFormat.isValid()) {
                    this.srcPictureFormat = new PictureFormat(width, height, PixelFormat.byId(this.avContext.pix_fmt()));
                }
                if (!this.dstPictureFormat.isValid()) {
                    this.dstPictureFormat = new PictureFormat(width, height, this.pixelFormat);
                }
                this.videoResampler = new PictureResampler();
                this.videoResampler.open(this.srcPictureFormat, this.dstPictureFormat);
            }
            if (!this.srcPictureFormat.equals(this.dstPictureFormat)) {
                if (this.picture == null) {
                    this.createImageBuffer();
                }
                this.videoResampler.resample(new avcodec.AVPicture((Pointer)this.avFrame), this.picture);
                channels = this.picture.linesize(0) / width;
                data = this.picture.data(0);
            } else {
                channels = this.avFrame.linesize(0) / width;
                data = this.avFrame.data(0);
            }
            data.position(0).capacity(width * height * channels);
            frame = new VideoFrame(data.asByteBuffer(), width, height, this.pixelFormat);
            frame.setKeyFrame(this.avFrame.key_frame() != 0);
            frame.setTimestamp(timestamp);
        } else if ((this.avPacket.data() == null || mPacket != null && mPacket.data() == null) && this.avPacket.size() == 0) {
            frame = null;
        }
        avcodec.av_free_packet((avcodec.AVPacket)this.avPacket);
        return frame;
    }

    private void createImageBuffer() throws JavaAVException {
        int format = this.pixelFormat.value();
        int width = this.avContext.width();
        int height = this.avContext.height();
        this.picture = new avcodec.AVPicture();
        if (avcodec.avpicture_alloc((avcodec.AVPicture)this.picture, (int)format, (int)width, (int)height) < 0) {
            throw new JavaAVException("Could not allocate picture.");
        }
    }
}

