/*
 * Decompiled with CFR 0.152.
 */
package com.github.hoary.javaav;

import com.github.hoary.javaav.CodecID;
import com.github.hoary.javaav.Configurable;
import com.github.hoary.javaav.Decoder;
import com.github.hoary.javaav.JavaAVException;
import com.github.hoary.javaav.MediaFrame;
import com.github.hoary.javaav.MediaPacket;
import com.github.hoary.javaav.PixelFormat;
import com.github.hoary.javaav.SampleFormat;
import com.googlecode.javacv.cpp.avcodec;
import com.googlecode.javacv.cpp.avformat;
import com.googlecode.javacv.cpp.avutil;

public class Demuxer
extends Configurable {
    private MediaPacket mediaPacket;
    private Decoder videoDecoder;
    private Decoder audioDecoder;
    private avformat.AVFormatContext formatContext;
    private avformat.AVStream videoStream;
    private avformat.AVStream audioStream;
    private avcodec.AVCodecContext videoCodecContext;
    private avcodec.AVCodecContext audioCodecContext;
    private avcodec.AVPacket avPacket;
    private String format = null;

    public void open(String inputPath) throws JavaAVException {
        this.videoDecoder = null;
        this.audioDecoder = null;
        avformat.AVInputFormat inputFormat = null;
        if (this.format != null && this.format.length() > 0 && (inputFormat = avformat.av_find_input_format((String)this.format)) == null) {
            throw new JavaAVException("Could not find input format: " + this.format);
        }
        this.formatContext = new avformat.AVFormatContext(null);
        avutil.AVDictionary options = new avutil.AVDictionary(null);
        if (this.frameRate > 0.0) {
            avutil.AVRational r = avutil.av_d2q((double)this.frameRate, (int)1001000);
            avutil.av_dict_set((avutil.AVDictionary)options, (String)"framerate", (String)(r.num() + "/" + r.den()), (int)0);
        }
        if (this.imageWidth > 0 && this.imageHeight > 0) {
            avutil.av_dict_set((avutil.AVDictionary)options, (String)"video_size", (String)(this.imageWidth + "x" + this.imageHeight), (int)0);
        }
        if (this.sampleRate > 0) {
            avutil.av_dict_set((avutil.AVDictionary)options, (String)"sample_rate", (String)("" + this.sampleRate), (int)0);
        }
        if (this.audioChannels > 0) {
            avutil.av_dict_set((avutil.AVDictionary)options, (String)"channels", (String)("" + this.audioChannels), (int)0);
        }
        if (avformat.avformat_open_input((avformat.AVFormatContext)this.formatContext, (String)inputPath, (avformat.AVInputFormat)inputFormat, (avutil.AVDictionary)options) < 0) {
            throw new JavaAVException("Could not open input: " + inputPath);
        }
        avutil.av_dict_free((avutil.AVDictionary)options);
        if (avformat.avformat_find_stream_info((avformat.AVFormatContext)this.formatContext, (avutil.AVDictionary)null) < 0) {
            throw new JavaAVException("Could not find stream information.");
        }
        int streams = this.formatContext.nb_streams();
        for (int i = 0; i < streams; ++i) {
            avformat.AVStream stream = this.formatContext.streams(i);
            avcodec.AVCodecContext context = stream.codec();
            if (this.videoStream == null && context.codec_type() == 0) {
                this.videoStream = stream;
                this.videoCodecContext = context;
                continue;
            }
            if (this.audioStream != null || context.codec_type() != 1) continue;
            this.audioStream = stream;
            this.audioCodecContext = context;
        }
        if (this.videoStream == null && this.audioStream == null) {
            throw new JavaAVException("Could not find any video or audio stream.");
        }
        if (this.videoCodecContext != null) {
            this.initVideoDecoder(this.videoCodecContext);
        }
        if (this.audioCodecContext != null) {
            this.initAudioDecoder(this.audioCodecContext);
        }
        this.avPacket = new avcodec.AVPacket();
    }

    public void close() {
        if (this.formatContext != null && !this.formatContext.isNull()) {
            avformat.avformat_close_input((avformat.AVFormatContext)this.formatContext);
            this.formatContext = null;
        }
        if (this.videoCodecContext != null) {
            this.videoCodecContext.setNull();
        }
        if (this.audioCodecContext != null) {
            this.audioCodecContext.setNull();
        }
        if (this.videoDecoder != null) {
            this.videoDecoder.close();
            this.videoDecoder = null;
        }
        if (this.audioDecoder != null) {
            this.audioDecoder.close();
            this.audioDecoder = null;
        }
    }

    public MediaFrame readFrame() throws JavaAVException {
        MediaFrame mediaFrame = new MediaFrame();
        while (mediaFrame != null && !mediaFrame.hasFrame()) {
            if (avformat.av_read_frame((avformat.AVFormatContext)this.formatContext, (avcodec.AVPacket)this.avPacket) < 0) {
                if (this.videoStream != null) {
                    this.avPacket.stream_index(this.videoStream.index());
                    this.avPacket.data(null);
                    this.avPacket.size(0);
                } else {
                    return null;
                }
            }
            this.mediaPacket = new MediaPacket(this.avPacket);
            if (this.videoStream != null && this.avPacket.stream_index() == this.videoStream.index()) {
                mediaFrame = this.videoDecoder.decodeVideo(this.mediaPacket);
            } else if (this.audioStream != null && this.avPacket.stream_index() == this.audioStream.index()) {
                mediaFrame = this.audioDecoder.decodeAudio(this.mediaPacket);
            }
            avcodec.av_free_packet((avcodec.AVPacket)this.avPacket);
        }
        return mediaFrame;
    }

    public void setInputFormat(String format) {
        this.format = format;
    }

    public String getInputFormat() {
        if (this.formatContext == null) {
            return this.format;
        }
        return this.formatContext.iformat().name().getString();
    }

    public int getImageWidth() {
        return this.videoDecoder == null ? super.getImageWidth() : this.videoDecoder.getImageWidth();
    }

    public int getImageHeight() {
        return this.videoDecoder == null ? super.getImageHeight() : this.videoDecoder.getImageHeight();
    }

    public int getAudioChannels() {
        return this.audioDecoder == null ? super.getAudioChannels() : this.audioDecoder.getAudioChannels();
    }

    public PixelFormat getPixelFormat() {
        return this.audioDecoder == null ? super.getPixelFormat() : this.audioDecoder.getPixelFormat();
    }

    public SampleFormat getSampleFormat() {
        return this.audioDecoder == null ? super.getSampleFormat() : this.audioDecoder.getSampleFormat();
    }

    public double getFrameRate() {
        if (this.videoStream == null) {
            return super.getFramerate();
        }
        avutil.AVRational rate = this.videoStream.r_frame_rate();
        return avutil.av_q2d((avutil.AVRational)rate);
    }

    public int getSampleRate() {
        return this.audioDecoder == null ? super.getSampleRate() : this.audioDecoder.getSampleRate();
    }

    private void initVideoDecoder(avcodec.AVCodecContext codecContext) {
        if (codecContext == null) {
            return;
        }
        try {
            CodecID codecId = CodecID.byId(codecContext.codec_id());
            this.videoDecoder = new Decoder(codecId, codecContext);
            this.videoDecoder.setPixelFormat(this.getPixelFormat());
            this.videoDecoder.open(null);
        }
        catch (JavaAVException e) {
            e.printStackTrace();
        }
    }

    private void initAudioDecoder(avcodec.AVCodecContext codecContext) {
        if (codecContext == null) {
            return;
        }
        try {
            CodecID codecId = CodecID.byId(codecContext.codec_id());
            this.audioDecoder = new Decoder(codecId, codecContext);
            this.audioDecoder.open(null);
        }
        catch (JavaAVException e) {
            e.printStackTrace();
        }
    }
}

