/*
 * Decompiled with CFR 0.152.
 */
package com.hframe.controller;

import com.hframe.domain.model.HfmdEnumClass;
import com.hframe.domain.model.HfmdEnumClass_Example;
import com.hframe.service.interfaces.IHfmdEnumClassSV;
import com.hframework.beans.controller.Pagination;
import com.hframework.beans.controller.ResultCode;
import com.hframework.beans.controller.ResultData;
import com.hframework.common.util.ExampleUtils;
import com.hframework.web.ControllerHelper;
import java.beans.PropertyEditor;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.propertyeditors.CustomDateEditor;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.ServletRequestDataBinder;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/hframe/hfmdEnumClass"})
public class HfmdEnumClassController {
    private static final Logger logger = LoggerFactory.getLogger(HfmdEnumClassController.class);
    @Resource
    private IHfmdEnumClassSV iHfmdEnumClassSV;

    @InitBinder
    protected void initBinder(HttpServletRequest request, ServletRequestDataBinder binder) throws Exception {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        CustomDateEditor editor = new CustomDateEditor((DateFormat)df, false);
        binder.registerCustomEditor(Date.class, (PropertyEditor)editor);
    }

    @RequestMapping(value={"/queryListByAjax.json"})
    @ResponseBody
    public ResultData list(@ModelAttribute(value="hfmdEnumClass") HfmdEnumClass hfmdEnumClass, @ModelAttribute(value="example") HfmdEnumClass_Example example, Pagination pagination) {
        logger.debug("request : {},{},{}", new Object[]{hfmdEnumClass, example, pagination});
        try {
            ExampleUtils.parseExample((Object)hfmdEnumClass, (Object)example);
            example.setLimitStart(pagination.getStartIndex());
            example.setLimitEnd(pagination.getEndIndex());
            List<HfmdEnumClass> list = this.iHfmdEnumClassSV.getHfmdEnumClassListByExample(example);
            pagination.setTotalCount(this.iHfmdEnumClassSV.getHfmdEnumClassCountByExample(example));
            return ResultData.success().add("list", list).add("pagination", (Object)pagination);
        }
        catch (Exception e) {
            logger.error("error : ", (Throwable)e);
            return ResultData.error((ResultCode)ResultCode.ERROR);
        }
    }

    @RequestMapping(value={"/queryOneByAjax.json"})
    @ResponseBody
    public ResultData detail(@ModelAttribute(value="hfmdEnumClass") HfmdEnumClass hfmdEnumClass) {
        logger.debug("request : {},{}", (Object)hfmdEnumClass.getHfmdEnumClassId(), (Object)hfmdEnumClass);
        try {
            HfmdEnumClass result = this.iHfmdEnumClassSV.getHfmdEnumClassByPK(hfmdEnumClass.getHfmdEnumClassId());
            if (result != null) {
                return ResultData.success((Object)result);
            }
            return ResultData.error((ResultCode)ResultCode.RECODE_IS_NOT_EXISTS);
        }
        catch (Exception e) {
            logger.error("error : ", (Throwable)e);
            return ResultData.error((ResultCode)ResultCode.ERROR);
        }
    }

    @RequestMapping(value={"/createByAjax.json"})
    @ResponseBody
    public ResultData create(@ModelAttribute(value="hfmdEnumClass") HfmdEnumClass hfmdEnumClass) {
        logger.debug("request : {}", (Object)hfmdEnumClass);
        try {
            ControllerHelper.setDefaultValue((Object)hfmdEnumClass, (String)"hfmdEnumClassId");
            int result = this.iHfmdEnumClassSV.create(hfmdEnumClass);
            if (result > 0) {
                return ResultData.success((Object)hfmdEnumClass);
            }
        }
        catch (Exception e) {
            logger.error("error : ", (Throwable)e);
            return ResultData.error((ResultCode)ResultCode.ERROR);
        }
        return ResultData.error((ResultCode)ResultCode.UNKNOW);
    }

    @RequestMapping(value={"/createsByAjax.json"})
    @ResponseBody
    public ResultData batchCreate(@RequestBody HfmdEnumClass[] hfmdEnumClasss) {
        logger.debug("request : {}", (Object[])hfmdEnumClasss);
        try {
            ControllerHelper.setDefaultValue((Object[])hfmdEnumClasss, (String)"hfmdEnumClassId");
            ControllerHelper.reorderProperty((Object[])hfmdEnumClasss);
            int result = this.iHfmdEnumClassSV.batchOperate(hfmdEnumClasss);
            if (result > 0) {
                return ResultData.success((Object)hfmdEnumClasss);
            }
        }
        catch (Exception e) {
            logger.error("error : ", (Throwable)e);
            return ResultData.error((ResultCode)ResultCode.ERROR);
        }
        return ResultData.error((ResultCode)ResultCode.UNKNOW);
    }

    @RequestMapping(value={"/updateByAjax.json"})
    @ResponseBody
    public ResultData update(@ModelAttribute(value="hfmdEnumClass") HfmdEnumClass hfmdEnumClass) {
        logger.debug("request : {}", (Object)hfmdEnumClass);
        try {
            ControllerHelper.setDefaultValue((Object)hfmdEnumClass, (String)"hfmdEnumClassId");
            int result = this.iHfmdEnumClassSV.update(hfmdEnumClass);
            if (result > 0) {
                return ResultData.success((Object)hfmdEnumClass);
            }
        }
        catch (Exception e) {
            logger.error("error : ", (Throwable)e);
            return ResultData.error((ResultCode)ResultCode.ERROR);
        }
        return ResultData.error((ResultCode)ResultCode.UNKNOW);
    }

    @RequestMapping(value={"/deleteByAjax.json"})
    @ResponseBody
    public ResultData delete(@ModelAttribute(value="hfmdEnumClass") HfmdEnumClass hfmdEnumClass) {
        logger.debug("request : {}", (Object)hfmdEnumClass);
        try {
            ControllerHelper.setDefaultValue((Object)hfmdEnumClass, (String)"hfmdEnumClassId");
            int result = this.iHfmdEnumClassSV.delete(hfmdEnumClass);
            if (result > 0) {
                return ResultData.success((Object)hfmdEnumClass);
            }
            return ResultData.error((ResultCode)ResultCode.RECODE_IS_NOT_EXISTS);
        }
        catch (Exception e) {
            logger.error("error : ", (Throwable)e);
            return ResultData.error((ResultCode)ResultCode.ERROR);
        }
    }

    public IHfmdEnumClassSV getIHfmdEnumClassSV() {
        return this.iHfmdEnumClassSV;
    }

    public void setIHfmdEnumClassSV(IHfmdEnumClassSV iHfmdEnumClassSV) {
        this.iHfmdEnumClassSV = iHfmdEnumClassSV;
    }
}

