/*
 * Decompiled with CFR 0.152.
 */
package com.hframe.controller;

import com.hframe.domain.model.HfmdEnum;
import com.hframe.domain.model.HfmdEnum_Example;
import com.hframe.service.interfaces.IHfmdEnumSV;
import com.hframework.beans.controller.Pagination;
import com.hframework.beans.controller.ResultCode;
import com.hframework.beans.controller.ResultData;
import com.hframework.common.util.ExampleUtils;
import com.hframework.web.ControllerHelper;
import java.beans.PropertyEditor;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.propertyeditors.CustomDateEditor;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.ServletRequestDataBinder;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/hframe/hfmdEnum"})
public class HfmdEnumController {
    private static final Logger logger = LoggerFactory.getLogger(HfmdEnumController.class);
    @Resource
    private IHfmdEnumSV iHfmdEnumSV;

    @InitBinder
    protected void initBinder(HttpServletRequest request, ServletRequestDataBinder binder) throws Exception {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        CustomDateEditor editor = new CustomDateEditor((DateFormat)df, false);
        binder.registerCustomEditor(Date.class, (PropertyEditor)editor);
    }

    @RequestMapping(value={"/queryListByAjax.json"})
    @ResponseBody
    public ResultData list(@ModelAttribute(value="hfmdEnum") HfmdEnum hfmdEnum, @ModelAttribute(value="example") HfmdEnum_Example example, Pagination pagination) {
        logger.debug("request : {},{},{}", new Object[]{hfmdEnum, example, pagination});
        try {
            ExampleUtils.parseExample((Object)hfmdEnum, (Object)example);
            example.setLimitStart(pagination.getStartIndex());
            example.setLimitEnd(pagination.getEndIndex());
            List<HfmdEnum> list = this.iHfmdEnumSV.getHfmdEnumListByExample(example);
            pagination.setTotalCount(this.iHfmdEnumSV.getHfmdEnumCountByExample(example));
            return ResultData.success().add("list", list).add("pagination", (Object)pagination);
        }
        catch (Exception e) {
            logger.error("error : ", (Throwable)e);
            return ResultData.error((ResultCode)ResultCode.ERROR);
        }
    }

    @RequestMapping(value={"/queryOneByAjax.json"})
    @ResponseBody
    public ResultData detail(@ModelAttribute(value="hfmdEnum") HfmdEnum hfmdEnum) {
        logger.debug("request : {},{}", (Object)hfmdEnum.getHfmdEnumId(), (Object)hfmdEnum);
        try {
            HfmdEnum result = this.iHfmdEnumSV.getHfmdEnumByPK(hfmdEnum.getHfmdEnumId());
            if (result != null) {
                return ResultData.success((Object)result);
            }
            return ResultData.error((ResultCode)ResultCode.RECODE_IS_NOT_EXISTS);
        }
        catch (Exception e) {
            logger.error("error : ", (Throwable)e);
            return ResultData.error((ResultCode)ResultCode.ERROR);
        }
    }

    @RequestMapping(value={"/createByAjax.json"})
    @ResponseBody
    public ResultData create(@ModelAttribute(value="hfmdEnum") HfmdEnum hfmdEnum) {
        logger.debug("request : {}", (Object)hfmdEnum);
        try {
            ControllerHelper.setDefaultValue((Object)hfmdEnum, (String)"hfmdEnumId");
            int result = this.iHfmdEnumSV.create(hfmdEnum);
            if (result > 0) {
                return ResultData.success((Object)hfmdEnum);
            }
        }
        catch (Exception e) {
            logger.error("error : ", (Throwable)e);
            return ResultData.error((ResultCode)ResultCode.ERROR);
        }
        return ResultData.error((ResultCode)ResultCode.UNKNOW);
    }

    @RequestMapping(value={"/createsByAjax.json"})
    @ResponseBody
    public ResultData batchCreate(@RequestBody HfmdEnum[] hfmdEnums) {
        logger.debug("request : {}", (Object[])hfmdEnums);
        try {
            ControllerHelper.setDefaultValue((Object[])hfmdEnums, (String)"hfmdEnumId");
            ControllerHelper.reorderProperty((Object[])hfmdEnums);
            int result = this.iHfmdEnumSV.batchOperate(hfmdEnums);
            if (result > 0) {
                return ResultData.success((Object)hfmdEnums);
            }
        }
        catch (Exception e) {
            logger.error("error : ", (Throwable)e);
            return ResultData.error((ResultCode)ResultCode.ERROR);
        }
        return ResultData.error((ResultCode)ResultCode.UNKNOW);
    }

    @RequestMapping(value={"/updateByAjax.json"})
    @ResponseBody
    public ResultData update(@ModelAttribute(value="hfmdEnum") HfmdEnum hfmdEnum) {
        logger.debug("request : {}", (Object)hfmdEnum);
        try {
            ControllerHelper.setDefaultValue((Object)hfmdEnum, (String)"hfmdEnumId");
            int result = this.iHfmdEnumSV.update(hfmdEnum);
            if (result > 0) {
                return ResultData.success((Object)hfmdEnum);
            }
        }
        catch (Exception e) {
            logger.error("error : ", (Throwable)e);
            return ResultData.error((ResultCode)ResultCode.ERROR);
        }
        return ResultData.error((ResultCode)ResultCode.UNKNOW);
    }

    @RequestMapping(value={"/deleteByAjax.json"})
    @ResponseBody
    public ResultData delete(@ModelAttribute(value="hfmdEnum") HfmdEnum hfmdEnum) {
        logger.debug("request : {}", (Object)hfmdEnum);
        try {
            ControllerHelper.setDefaultValue((Object)hfmdEnum, (String)"hfmdEnumId");
            int result = this.iHfmdEnumSV.delete(hfmdEnum);
            if (result > 0) {
                return ResultData.success((Object)hfmdEnum);
            }
            return ResultData.error((ResultCode)ResultCode.RECODE_IS_NOT_EXISTS);
        }
        catch (Exception e) {
            logger.error("error : ", (Throwable)e);
            return ResultData.error((ResultCode)ResultCode.ERROR);
        }
    }

    public IHfmdEnumSV getIHfmdEnumSV() {
        return this.iHfmdEnumSV;
    }

    public void setIHfmdEnumSV(IHfmdEnumSV iHfmdEnumSV) {
        this.iHfmdEnumSV = iHfmdEnumSV;
    }
}

