/*
 * Decompiled with CFR 0.152.
 */
package com.hframe.controller;

import com.hframe.domain.model.HfpmDataSet;
import com.hframe.domain.model.HfpmDataSet_Example;
import com.hframe.service.interfaces.IHfpmDataSetSV;
import com.hframework.beans.controller.Pagination;
import com.hframework.beans.controller.ResultCode;
import com.hframework.beans.controller.ResultData;
import com.hframework.common.util.ExampleUtils;
import com.hframework.web.ControllerHelper;
import java.beans.PropertyEditor;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.propertyeditors.CustomDateEditor;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.ServletRequestDataBinder;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/hframe/hfpmDataSet"})
public class HfpmDataSetController {
    private static final Logger logger = LoggerFactory.getLogger(HfpmDataSetController.class);
    @Resource
    private IHfpmDataSetSV iHfpmDataSetSV;

    @InitBinder
    protected void initBinder(HttpServletRequest request, ServletRequestDataBinder binder) throws Exception {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        CustomDateEditor editor = new CustomDateEditor((DateFormat)df, false);
        binder.registerCustomEditor(Date.class, (PropertyEditor)editor);
    }

    @RequestMapping(value={"/queryListByAjax.json"})
    @ResponseBody
    public ResultData list(@ModelAttribute(value="hfpmDataSet") HfpmDataSet hfpmDataSet, @ModelAttribute(value="example") HfpmDataSet_Example example, Pagination pagination) {
        logger.debug("request : {},{},{}", new Object[]{hfpmDataSet, example, pagination});
        try {
            ExampleUtils.parseExample((Object)hfpmDataSet, (Object)example);
            example.setLimitStart(pagination.getStartIndex());
            example.setLimitEnd(pagination.getEndIndex());
            List<HfpmDataSet> list = this.iHfpmDataSetSV.getHfpmDataSetListByExample(example);
            pagination.setTotalCount(this.iHfpmDataSetSV.getHfpmDataSetCountByExample(example));
            return ResultData.success().add("list", list).add("pagination", (Object)pagination);
        }
        catch (Exception e) {
            logger.error("error : ", (Throwable)e);
            return ResultData.error((ResultCode)ResultCode.ERROR);
        }
    }

    @RequestMapping(value={"/queryOneByAjax.json"})
    @ResponseBody
    public ResultData detail(@ModelAttribute(value="hfpmDataSet") HfpmDataSet hfpmDataSet) {
        logger.debug("request : {},{}", (Object)hfpmDataSet.getHfpmDataSetId(), (Object)hfpmDataSet);
        try {
            HfpmDataSet result = this.iHfpmDataSetSV.getHfpmDataSetByPK(hfpmDataSet.getHfpmDataSetId());
            if (result != null) {
                return ResultData.success((Object)result);
            }
            return ResultData.error((ResultCode)ResultCode.RECODE_IS_NOT_EXISTS);
        }
        catch (Exception e) {
            logger.error("error : ", (Throwable)e);
            return ResultData.error((ResultCode)ResultCode.ERROR);
        }
    }

    @RequestMapping(value={"/createByAjax.json"})
    @ResponseBody
    public ResultData create(@ModelAttribute(value="hfpmDataSet") HfpmDataSet hfpmDataSet) {
        logger.debug("request : {}", (Object)hfpmDataSet);
        try {
            ControllerHelper.setDefaultValue((Object)hfpmDataSet, (String)"hfpmDataSetId");
            int result = this.iHfpmDataSetSV.create(hfpmDataSet);
            if (result > 0) {
                return ResultData.success((Object)hfpmDataSet);
            }
        }
        catch (Exception e) {
            logger.error("error : ", (Throwable)e);
            return ResultData.error((ResultCode)ResultCode.ERROR);
        }
        return ResultData.error((ResultCode)ResultCode.UNKNOW);
    }

    @RequestMapping(value={"/createsByAjax.json"})
    @ResponseBody
    public ResultData batchCreate(@RequestBody HfpmDataSet[] hfpmDataSets) {
        logger.debug("request : {}", (Object[])hfpmDataSets);
        try {
            ControllerHelper.setDefaultValue((Object[])hfpmDataSets, (String)"hfpmDataSetId");
            ControllerHelper.reorderProperty((Object[])hfpmDataSets);
            int result = this.iHfpmDataSetSV.batchOperate(hfpmDataSets);
            if (result > 0) {
                return ResultData.success((Object)hfpmDataSets);
            }
        }
        catch (Exception e) {
            logger.error("error : ", (Throwable)e);
            return ResultData.error((ResultCode)ResultCode.ERROR);
        }
        return ResultData.error((ResultCode)ResultCode.UNKNOW);
    }

    @RequestMapping(value={"/updateByAjax.json"})
    @ResponseBody
    public ResultData update(@ModelAttribute(value="hfpmDataSet") HfpmDataSet hfpmDataSet) {
        logger.debug("request : {}", (Object)hfpmDataSet);
        try {
            ControllerHelper.setDefaultValue((Object)hfpmDataSet, (String)"hfpmDataSetId");
            int result = this.iHfpmDataSetSV.update(hfpmDataSet);
            if (result > 0) {
                return ResultData.success((Object)hfpmDataSet);
            }
        }
        catch (Exception e) {
            logger.error("error : ", (Throwable)e);
            return ResultData.error((ResultCode)ResultCode.ERROR);
        }
        return ResultData.error((ResultCode)ResultCode.UNKNOW);
    }

    @RequestMapping(value={"/deleteByAjax.json"})
    @ResponseBody
    public ResultData delete(@ModelAttribute(value="hfpmDataSet") HfpmDataSet hfpmDataSet) {
        logger.debug("request : {}", (Object)hfpmDataSet);
        try {
            ControllerHelper.setDefaultValue((Object)hfpmDataSet, (String)"hfpmDataSetId");
            int result = this.iHfpmDataSetSV.delete(hfpmDataSet);
            if (result > 0) {
                return ResultData.success((Object)hfpmDataSet);
            }
            return ResultData.error((ResultCode)ResultCode.RECODE_IS_NOT_EXISTS);
        }
        catch (Exception e) {
            logger.error("error : ", (Throwable)e);
            return ResultData.error((ResultCode)ResultCode.ERROR);
        }
    }

    public IHfpmDataSetSV getIHfpmDataSetSV() {
        return this.iHfpmDataSetSV;
    }

    public void setIHfpmDataSetSV(IHfpmDataSetSV iHfpmDataSetSV) {
        this.iHfpmDataSetSV = iHfpmDataSetSV;
    }
}

