/*
 * Decompiled with CFR 0.152.
 */
package com.hframe.controller;

import com.hframe.domain.model.HfpmModule;
import com.hframe.domain.model.HfpmModule_Example;
import com.hframe.service.interfaces.IHfpmModuleSV;
import com.hframework.beans.controller.Pagination;
import com.hframework.beans.controller.ResultCode;
import com.hframework.beans.controller.ResultData;
import com.hframework.common.util.ExampleUtils;
import com.hframework.web.ControllerHelper;
import java.beans.PropertyEditor;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.propertyeditors.CustomDateEditor;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.ServletRequestDataBinder;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/hframe/hfpmModule"})
public class HfpmModuleController {
    private static final Logger logger = LoggerFactory.getLogger(HfpmModuleController.class);
    @Resource
    private IHfpmModuleSV iHfpmModuleSV;

    @InitBinder
    protected void initBinder(HttpServletRequest request, ServletRequestDataBinder binder) throws Exception {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        CustomDateEditor editor = new CustomDateEditor((DateFormat)df, false);
        binder.registerCustomEditor(Date.class, (PropertyEditor)editor);
    }

    @RequestMapping(value={"/queryListByAjax.json"})
    @ResponseBody
    public ResultData list(@ModelAttribute(value="hfpmModule") HfpmModule hfpmModule, @ModelAttribute(value="example") HfpmModule_Example example, Pagination pagination) {
        logger.debug("request : {},{},{}", new Object[]{hfpmModule, example, pagination});
        try {
            ExampleUtils.parseExample((Object)hfpmModule, (Object)example);
            example.setLimitStart(pagination.getStartIndex());
            example.setLimitEnd(pagination.getEndIndex());
            List<HfpmModule> list = this.iHfpmModuleSV.getHfpmModuleListByExample(example);
            pagination.setTotalCount(this.iHfpmModuleSV.getHfpmModuleCountByExample(example));
            return ResultData.success().add("list", list).add("pagination", (Object)pagination);
        }
        catch (Exception e) {
            logger.error("error : ", (Throwable)e);
            return ResultData.error((ResultCode)ResultCode.ERROR);
        }
    }

    @RequestMapping(value={"/queryOneByAjax.json"})
    @ResponseBody
    public ResultData detail(@ModelAttribute(value="hfpmModule") HfpmModule hfpmModule) {
        logger.debug("request : {},{}", (Object)hfpmModule.getHfpmModuleId(), (Object)hfpmModule);
        try {
            HfpmModule result = this.iHfpmModuleSV.getHfpmModuleByPK(hfpmModule.getHfpmModuleId());
            if (result != null) {
                return ResultData.success((Object)result);
            }
            return ResultData.error((ResultCode)ResultCode.RECODE_IS_NOT_EXISTS);
        }
        catch (Exception e) {
            logger.error("error : ", (Throwable)e);
            return ResultData.error((ResultCode)ResultCode.ERROR);
        }
    }

    @RequestMapping(value={"/createByAjax.json"})
    @ResponseBody
    public ResultData create(@ModelAttribute(value="hfpmModule") HfpmModule hfpmModule) {
        logger.debug("request : {}", (Object)hfpmModule);
        try {
            ControllerHelper.setDefaultValue((Object)hfpmModule, (String)"hfpmModuleId");
            int result = this.iHfpmModuleSV.create(hfpmModule);
            if (result > 0) {
                return ResultData.success((Object)hfpmModule);
            }
        }
        catch (Exception e) {
            logger.error("error : ", (Throwable)e);
            return ResultData.error((ResultCode)ResultCode.ERROR);
        }
        return ResultData.error((ResultCode)ResultCode.UNKNOW);
    }

    @RequestMapping(value={"/createsByAjax.json"})
    @ResponseBody
    public ResultData batchCreate(@RequestBody HfpmModule[] hfpmModules) {
        logger.debug("request : {}", (Object[])hfpmModules);
        try {
            ControllerHelper.setDefaultValue((Object[])hfpmModules, (String)"hfpmModuleId");
            ControllerHelper.reorderProperty((Object[])hfpmModules);
            int result = this.iHfpmModuleSV.batchOperate(hfpmModules);
            if (result > 0) {
                return ResultData.success((Object)hfpmModules);
            }
        }
        catch (Exception e) {
            logger.error("error : ", (Throwable)e);
            return ResultData.error((ResultCode)ResultCode.ERROR);
        }
        return ResultData.error((ResultCode)ResultCode.UNKNOW);
    }

    @RequestMapping(value={"/updateByAjax.json"})
    @ResponseBody
    public ResultData update(@ModelAttribute(value="hfpmModule") HfpmModule hfpmModule) {
        logger.debug("request : {}", (Object)hfpmModule);
        try {
            ControllerHelper.setDefaultValue((Object)hfpmModule, (String)"hfpmModuleId");
            int result = this.iHfpmModuleSV.update(hfpmModule);
            if (result > 0) {
                return ResultData.success((Object)hfpmModule);
            }
        }
        catch (Exception e) {
            logger.error("error : ", (Throwable)e);
            return ResultData.error((ResultCode)ResultCode.ERROR);
        }
        return ResultData.error((ResultCode)ResultCode.UNKNOW);
    }

    @RequestMapping(value={"/deleteByAjax.json"})
    @ResponseBody
    public ResultData delete(@ModelAttribute(value="hfpmModule") HfpmModule hfpmModule) {
        logger.debug("request : {}", (Object)hfpmModule);
        try {
            ControllerHelper.setDefaultValue((Object)hfpmModule, (String)"hfpmModuleId");
            int result = this.iHfpmModuleSV.delete(hfpmModule);
            if (result > 0) {
                return ResultData.success((Object)hfpmModule);
            }
            return ResultData.error((ResultCode)ResultCode.RECODE_IS_NOT_EXISTS);
        }
        catch (Exception e) {
            logger.error("error : ", (Throwable)e);
            return ResultData.error((ResultCode)ResultCode.ERROR);
        }
    }

    public IHfpmModuleSV getIHfpmModuleSV() {
        return this.iHfpmModuleSV;
    }

    public void setIHfpmModuleSV(IHfpmModuleSV iHfpmModuleSV) {
        this.iHfpmModuleSV = iHfpmModuleSV;
    }
}

