/*
 * Decompiled with CFR 0.152.
 */
package com.hframe.controller;

import com.hframe.domain.model.HfpmPage;
import com.hframe.domain.model.HfpmPage_Example;
import com.hframe.service.interfaces.IHfpmPageSV;
import com.hframework.beans.controller.Pagination;
import com.hframework.beans.controller.ResultCode;
import com.hframework.beans.controller.ResultData;
import com.hframework.common.util.ExampleUtils;
import com.hframework.web.ControllerHelper;
import java.beans.PropertyEditor;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.propertyeditors.CustomDateEditor;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.ServletRequestDataBinder;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/hframe/hfpmPage"})
public class HfpmPageController {
    private static final Logger logger = LoggerFactory.getLogger(HfpmPageController.class);
    @Resource
    private IHfpmPageSV iHfpmPageSV;

    @InitBinder
    protected void initBinder(HttpServletRequest request, ServletRequestDataBinder binder) throws Exception {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        CustomDateEditor editor = new CustomDateEditor((DateFormat)df, false);
        binder.registerCustomEditor(Date.class, (PropertyEditor)editor);
    }

    @RequestMapping(value={"/queryListByAjax.json"})
    @ResponseBody
    public ResultData list(@ModelAttribute(value="hfpmPage") HfpmPage hfpmPage, @ModelAttribute(value="example") HfpmPage_Example example, Pagination pagination) {
        logger.debug("request : {},{},{}", new Object[]{hfpmPage, example, pagination});
        try {
            ExampleUtils.parseExample((Object)hfpmPage, (Object)example);
            example.setLimitStart(pagination.getStartIndex());
            example.setLimitEnd(pagination.getEndIndex());
            List<HfpmPage> list = this.iHfpmPageSV.getHfpmPageListByExample(example);
            pagination.setTotalCount(this.iHfpmPageSV.getHfpmPageCountByExample(example));
            return ResultData.success().add("list", list).add("pagination", (Object)pagination);
        }
        catch (Exception e) {
            logger.error("error : ", (Throwable)e);
            return ResultData.error((ResultCode)ResultCode.ERROR);
        }
    }

    @RequestMapping(value={"/queryOneByAjax.json"})
    @ResponseBody
    public ResultData detail(@ModelAttribute(value="hfpmPage") HfpmPage hfpmPage) {
        logger.debug("request : {},{}", (Object)hfpmPage.getHfpmPageId(), (Object)hfpmPage);
        try {
            HfpmPage result = this.iHfpmPageSV.getHfpmPageByPK(hfpmPage.getHfpmPageId());
            if (result != null) {
                return ResultData.success((Object)result);
            }
            return ResultData.error((ResultCode)ResultCode.RECODE_IS_NOT_EXISTS);
        }
        catch (Exception e) {
            logger.error("error : ", (Throwable)e);
            return ResultData.error((ResultCode)ResultCode.ERROR);
        }
    }

    @RequestMapping(value={"/searchOneByAjax.json"})
    @ResponseBody
    public ResultData search(@ModelAttribute(value=" hfpmPage") HfpmPage hfpmPage) {
        logger.debug("request : {}", (Object)hfpmPage);
        try {
            HfpmPage result = null;
            if (hfpmPage.getHfpmPageId() != null) {
                result = this.iHfpmPageSV.getHfpmPageByPK(hfpmPage.getHfpmPageId());
            } else {
                HfpmPage_Example example = (HfpmPage_Example)ExampleUtils.parseExample((Object)hfpmPage, HfpmPage_Example.class);
                example.setLimitStart(0);
                example.setLimitEnd(1);
                List<HfpmPage> list = this.iHfpmPageSV.getHfpmPageListByExample(example);
                if (list != null && list.size() > 0) {
                    result = list.get(0);
                }
            }
            if (result != null) {
                return ResultData.success((Object)result);
            }
            return ResultData.error((ResultCode)ResultCode.RECODE_IS_NOT_EXISTS);
        }
        catch (Exception e) {
            logger.error("error : ", (Throwable)e);
            return ResultData.error((ResultCode)ResultCode.ERROR);
        }
    }

    @RequestMapping(value={"/createByAjax.json"})
    @ResponseBody
    public ResultData create(@ModelAttribute(value="hfpmPage") HfpmPage hfpmPage) {
        logger.debug("request : {}", (Object)hfpmPage);
        try {
            ControllerHelper.setDefaultValue((Object)hfpmPage, (String)"hfpmPageId");
            int result = this.iHfpmPageSV.create(hfpmPage);
            if (result > 0) {
                return ResultData.success((Object)hfpmPage);
            }
        }
        catch (Exception e) {
            logger.error("error : ", (Throwable)e);
            return ResultData.error((ResultCode)ResultCode.ERROR);
        }
        return ResultData.error((ResultCode)ResultCode.UNKNOW);
    }

    @RequestMapping(value={"/createsByAjax.json"})
    @ResponseBody
    public ResultData batchCreate(@RequestBody HfpmPage[] hfpmPages) {
        logger.debug("request : {}", (Object[])hfpmPages);
        try {
            ControllerHelper.setDefaultValue((Object[])hfpmPages, (String)"hfpmPageId");
            ControllerHelper.reorderProperty((Object[])hfpmPages);
            int result = this.iHfpmPageSV.batchOperate(hfpmPages);
            if (result > 0) {
                return ResultData.success((Object)hfpmPages);
            }
        }
        catch (Exception e) {
            logger.error("error : ", (Throwable)e);
            return ResultData.error((ResultCode)ResultCode.ERROR);
        }
        return ResultData.error((ResultCode)ResultCode.UNKNOW);
    }

    @RequestMapping(value={"/updateByAjax.json"})
    @ResponseBody
    public ResultData update(@ModelAttribute(value="hfpmPage") HfpmPage hfpmPage) {
        logger.debug("request : {}", (Object)hfpmPage);
        try {
            ControllerHelper.setDefaultValue((Object)hfpmPage, (String)"hfpmPageId");
            int result = this.iHfpmPageSV.update(hfpmPage);
            if (result > 0) {
                return ResultData.success((Object)hfpmPage);
            }
        }
        catch (Exception e) {
            logger.error("error : ", (Throwable)e);
            return ResultData.error((ResultCode)ResultCode.ERROR);
        }
        return ResultData.error((ResultCode)ResultCode.UNKNOW);
    }

    @RequestMapping(value={"/deleteByAjax.json"})
    @ResponseBody
    public ResultData delete(@ModelAttribute(value="hfpmPage") HfpmPage hfpmPage) {
        logger.debug("request : {}", (Object)hfpmPage);
        try {
            ControllerHelper.setDefaultValue((Object)hfpmPage, (String)"hfpmPageId");
            int result = this.iHfpmPageSV.delete(hfpmPage);
            if (result > 0) {
                return ResultData.success((Object)hfpmPage);
            }
            return ResultData.error((ResultCode)ResultCode.RECODE_IS_NOT_EXISTS);
        }
        catch (Exception e) {
            logger.error("error : ", (Throwable)e);
            return ResultData.error((ResultCode)ResultCode.ERROR);
        }
    }

    public IHfpmPageSV getIHfpmPageSV() {
        return this.iHfpmPageSV;
    }

    public void setIHfpmPageSV(IHfpmPageSV iHfpmPageSV) {
        this.iHfpmPageSV = iHfpmPageSV;
    }
}

