/*
 * Decompiled with CFR 0.152.
 */
package com.hframe.controller;

import com.hframe.domain.model.HfpmProgram;
import com.hframe.domain.model.HfpmProgram_Example;
import com.hframe.service.interfaces.IHfpmProgramSV;
import com.hframework.beans.controller.Pagination;
import com.hframework.beans.controller.ResultCode;
import com.hframework.beans.controller.ResultData;
import com.hframework.common.util.ExampleUtils;
import com.hframework.web.ControllerHelper;
import java.beans.PropertyEditor;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.propertyeditors.CustomDateEditor;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.ServletRequestDataBinder;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/hframe/hfpmProgram"})
public class HfpmProgramController {
    private static final Logger logger = LoggerFactory.getLogger(HfpmProgramController.class);
    @Resource
    private IHfpmProgramSV iHfpmProgramSV;

    @InitBinder
    protected void initBinder(HttpServletRequest request, ServletRequestDataBinder binder) throws Exception {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        CustomDateEditor editor = new CustomDateEditor((DateFormat)df, false);
        binder.registerCustomEditor(Date.class, (PropertyEditor)editor);
    }

    @RequestMapping(value={"/queryListByAjax.json"})
    @ResponseBody
    public ResultData list(@ModelAttribute(value="hfpmProgram") HfpmProgram hfpmProgram, @ModelAttribute(value="example") HfpmProgram_Example example, Pagination pagination) {
        logger.debug("request : {},{},{}", new Object[]{hfpmProgram, example, pagination});
        try {
            ExampleUtils.parseExample((Object)hfpmProgram, (Object)example);
            example.setLimitStart(pagination.getStartIndex());
            example.setLimitEnd(pagination.getEndIndex());
            List<HfpmProgram> list = this.iHfpmProgramSV.getHfpmProgramListByExample(example);
            pagination.setTotalCount(this.iHfpmProgramSV.getHfpmProgramCountByExample(example));
            return ResultData.success().add("list", list).add("pagination", (Object)pagination);
        }
        catch (Exception e) {
            logger.error("error : ", (Throwable)e);
            return ResultData.error((ResultCode)ResultCode.ERROR);
        }
    }

    @RequestMapping(value={"/queryOneByAjax.json"})
    @ResponseBody
    public ResultData detail(@ModelAttribute(value="hfpmProgram") HfpmProgram hfpmProgram) {
        logger.debug("request : {},{}", (Object)hfpmProgram.getHfpmProgramId(), (Object)hfpmProgram);
        try {
            HfpmProgram result = this.iHfpmProgramSV.getHfpmProgramByPK(hfpmProgram.getHfpmProgramId());
            if (result != null) {
                return ResultData.success((Object)result);
            }
            return ResultData.error((ResultCode)ResultCode.RECODE_IS_NOT_EXISTS);
        }
        catch (Exception e) {
            logger.error("error : ", (Throwable)e);
            return ResultData.error((ResultCode)ResultCode.ERROR);
        }
    }

    @RequestMapping(value={"/createByAjax.json"})
    @ResponseBody
    public ResultData create(@ModelAttribute(value="hfpmProgram") HfpmProgram hfpmProgram) {
        logger.debug("request : {}", (Object)hfpmProgram);
        try {
            ControllerHelper.setDefaultValue((Object)hfpmProgram, (String)"hfpmProgramId");
            int result = this.iHfpmProgramSV.create(hfpmProgram);
            if (result > 0) {
                return ResultData.success((Object)hfpmProgram);
            }
        }
        catch (Exception e) {
            logger.error("error : ", (Throwable)e);
            return ResultData.error((ResultCode)ResultCode.ERROR);
        }
        return ResultData.error((ResultCode)ResultCode.UNKNOW);
    }

    @RequestMapping(value={"/createsByAjax.json"})
    @ResponseBody
    public ResultData batchCreate(@RequestBody HfpmProgram[] hfpmPrograms) {
        logger.debug("request : {}", (Object[])hfpmPrograms);
        try {
            ControllerHelper.setDefaultValue((Object[])hfpmPrograms, (String)"hfpmProgramId");
            ControllerHelper.reorderProperty((Object[])hfpmPrograms);
            int result = this.iHfpmProgramSV.batchOperate(hfpmPrograms);
            if (result > 0) {
                return ResultData.success((Object)hfpmPrograms);
            }
        }
        catch (Exception e) {
            logger.error("error : ", (Throwable)e);
            return ResultData.error((ResultCode)ResultCode.ERROR);
        }
        return ResultData.error((ResultCode)ResultCode.UNKNOW);
    }

    @RequestMapping(value={"/updateByAjax.json"})
    @ResponseBody
    public ResultData update(@ModelAttribute(value="hfpmProgram") HfpmProgram hfpmProgram) {
        logger.debug("request : {}", (Object)hfpmProgram);
        try {
            ControllerHelper.setDefaultValue((Object)hfpmProgram, (String)"hfpmProgramId");
            int result = this.iHfpmProgramSV.update(hfpmProgram);
            if (result > 0) {
                return ResultData.success((Object)hfpmProgram);
            }
        }
        catch (Exception e) {
            logger.error("error : ", (Throwable)e);
            return ResultData.error((ResultCode)ResultCode.ERROR);
        }
        return ResultData.error((ResultCode)ResultCode.UNKNOW);
    }

    @RequestMapping(value={"/deleteByAjax.json"})
    @ResponseBody
    public ResultData delete(@ModelAttribute(value="hfpmProgram") HfpmProgram hfpmProgram) {
        logger.debug("request : {}", (Object)hfpmProgram);
        try {
            ControllerHelper.setDefaultValue((Object)hfpmProgram, (String)"hfpmProgramId");
            int result = this.iHfpmProgramSV.delete(hfpmProgram);
            if (result > 0) {
                return ResultData.success((Object)hfpmProgram);
            }
            return ResultData.error((ResultCode)ResultCode.RECODE_IS_NOT_EXISTS);
        }
        catch (Exception e) {
            logger.error("error : ", (Throwable)e);
            return ResultData.error((ResultCode)ResultCode.ERROR);
        }
    }

    public IHfpmProgramSV getIHfpmProgramSV() {
        return this.iHfpmProgramSV;
    }

    public void setIHfpmProgramSV(IHfpmProgramSV iHfpmProgramSV) {
        this.iHfpmProgramSV = iHfpmProgramSV;
    }
}

