/*
 * Decompiled with CFR 0.152.
 */
package com.hframe.controller;

import com.hframe.domain.model.HfpmTest;
import com.hframe.domain.model.HfpmTest_Example;
import com.hframe.service.interfaces.IHfpmTestSV;
import com.hframework.beans.controller.Pagination;
import com.hframework.beans.controller.ResultCode;
import com.hframework.beans.controller.ResultData;
import com.hframework.common.util.ExampleUtils;
import com.hframework.web.ControllerHelper;
import java.beans.PropertyEditor;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.propertyeditors.CustomDateEditor;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.ServletRequestDataBinder;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/hframe/hfpmTest"})
public class HfpmTestController {
    private static final Logger logger = LoggerFactory.getLogger(HfpmTestController.class);
    @Resource
    private IHfpmTestSV iHfpmTestSV;

    @InitBinder
    protected void initBinder(HttpServletRequest request, ServletRequestDataBinder binder) throws Exception {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        CustomDateEditor editor = new CustomDateEditor((DateFormat)df, false);
        binder.registerCustomEditor(Date.class, (PropertyEditor)editor);
    }

    @RequestMapping(value={"/queryListByAjax.json"})
    @ResponseBody
    public ResultData list(@ModelAttribute(value="hfpmTest") HfpmTest hfpmTest, @ModelAttribute(value="example") HfpmTest_Example example, Pagination pagination) {
        logger.debug("request : {},{},{}", new Object[]{hfpmTest, example, pagination});
        try {
            ExampleUtils.parseExample((Object)hfpmTest, (Object)example);
            example.setLimitStart(pagination.getStartIndex());
            example.setLimitEnd(pagination.getEndIndex());
            List<HfpmTest> list = this.iHfpmTestSV.getHfpmTestListByExample(example);
            pagination.setTotalCount(this.iHfpmTestSV.getHfpmTestCountByExample(example));
            return ResultData.success().add("list", list).add("pagination", (Object)pagination);
        }
        catch (Exception e) {
            logger.error("error : ", (Throwable)e);
            return ResultData.error((ResultCode)ResultCode.ERROR);
        }
    }

    @RequestMapping(value={"/queryOneByAjax.json"})
    @ResponseBody
    public ResultData detail(@ModelAttribute(value="hfpmTest") HfpmTest hfpmTest) {
        logger.debug("request : {},{}", (Object)hfpmTest.getHfpmTestId(), (Object)hfpmTest);
        try {
            HfpmTest result = this.iHfpmTestSV.getHfpmTestByPK(hfpmTest.getHfpmTestId());
            if (result != null) {
                return ResultData.success((Object)result);
            }
            return ResultData.error((ResultCode)ResultCode.RECODE_IS_NOT_EXISTS);
        }
        catch (Exception e) {
            logger.error("error : ", (Throwable)e);
            return ResultData.error((ResultCode)ResultCode.ERROR);
        }
    }

    @RequestMapping(value={"/searchOneByAjax.json"})
    @ResponseBody
    public ResultData search(@ModelAttribute(value=" hfpmTest") HfpmTest hfpmTest) {
        logger.debug("request : {}", (Object)hfpmTest);
        try {
            HfpmTest result = null;
            if (hfpmTest.getHfpmTestId() != null) {
                result = this.iHfpmTestSV.getHfpmTestByPK(hfpmTest.getHfpmTestId());
            } else {
                HfpmTest_Example example = (HfpmTest_Example)ExampleUtils.parseExample((Object)hfpmTest, HfpmTest_Example.class);
                example.setLimitStart(0);
                example.setLimitEnd(1);
                List<HfpmTest> list = this.iHfpmTestSV.getHfpmTestListByExample(example);
                if (list != null && list.size() > 0) {
                    result = list.get(0);
                }
            }
            if (result != null) {
                return ResultData.success((Object)result);
            }
            return ResultData.error((ResultCode)ResultCode.RECODE_IS_NOT_EXISTS);
        }
        catch (Exception e) {
            logger.error("error : ", (Throwable)e);
            return ResultData.error((ResultCode)ResultCode.ERROR);
        }
    }

    @RequestMapping(value={"/createByAjax.json"})
    @ResponseBody
    public ResultData create(@ModelAttribute(value="hfpmTest") HfpmTest hfpmTest) {
        logger.debug("request : {}", (Object)hfpmTest);
        try {
            ControllerHelper.setDefaultValue((Object)hfpmTest, (String)"hfpmTestId");
            int result = this.iHfpmTestSV.create(hfpmTest);
            if (result > 0) {
                return ResultData.success((Object)hfpmTest);
            }
        }
        catch (Exception e) {
            logger.error("error : ", (Throwable)e);
            return ResultData.error((ResultCode)ResultCode.ERROR);
        }
        return ResultData.error((ResultCode)ResultCode.UNKNOW);
    }

    @RequestMapping(value={"/createsByAjax.json"})
    @ResponseBody
    public ResultData batchCreate(@RequestBody HfpmTest[] hfpmTests) {
        logger.debug("request : {}", (Object[])hfpmTests);
        try {
            ControllerHelper.setDefaultValue((Object[])hfpmTests, (String)"hfpmTestId");
            ControllerHelper.reorderProperty((Object[])hfpmTests);
            int result = this.iHfpmTestSV.batchOperate(hfpmTests);
            if (result > 0) {
                return ResultData.success((Object)hfpmTests);
            }
        }
        catch (Exception e) {
            logger.error("error : ", (Throwable)e);
            return ResultData.error((ResultCode)ResultCode.ERROR);
        }
        return ResultData.error((ResultCode)ResultCode.UNKNOW);
    }

    @RequestMapping(value={"/updateByAjax.json"})
    @ResponseBody
    public ResultData update(@ModelAttribute(value="hfpmTest") HfpmTest hfpmTest) {
        logger.debug("request : {}", (Object)hfpmTest);
        try {
            ControllerHelper.setDefaultValue((Object)hfpmTest, (String)"hfpmTestId");
            int result = this.iHfpmTestSV.update(hfpmTest);
            if (result > 0) {
                return ResultData.success((Object)hfpmTest);
            }
        }
        catch (Exception e) {
            logger.error("error : ", (Throwable)e);
            return ResultData.error((ResultCode)ResultCode.ERROR);
        }
        return ResultData.error((ResultCode)ResultCode.UNKNOW);
    }

    @RequestMapping(value={"/deleteByAjax.json"})
    @ResponseBody
    public ResultData delete(@ModelAttribute(value="hfpmTest") HfpmTest hfpmTest) {
        logger.debug("request : {}", (Object)hfpmTest);
        try {
            ControllerHelper.setDefaultValue((Object)hfpmTest, (String)"hfpmTestId");
            int result = this.iHfpmTestSV.delete(hfpmTest);
            if (result > 0) {
                return ResultData.success((Object)hfpmTest);
            }
            return ResultData.error((ResultCode)ResultCode.RECODE_IS_NOT_EXISTS);
        }
        catch (Exception e) {
            logger.error("error : ", (Throwable)e);
            return ResultData.error((ResultCode)ResultCode.ERROR);
        }
    }

    public IHfpmTestSV getIHfpmTestSV() {
        return this.iHfpmTestSV;
    }

    public void setIHfpmTestSV(IHfpmTestSV iHfpmTestSV) {
        this.iHfpmTestSV = iHfpmTestSV;
    }
}

