/*
 * Decompiled with CFR 0.152.
 */
package com.hframe.controller;

import com.hframe.domain.model.HfsecUser;
import com.hframe.domain.model.HfsecUser_Example;
import com.hframe.service.interfaces.IHfsecUserSV;
import com.hframework.beans.controller.Pagination;
import com.hframework.beans.controller.ResultCode;
import com.hframework.beans.controller.ResultData;
import com.hframework.beans.exceptions.BusinessException;
import com.hframework.common.util.ExampleUtils;
import com.hframework.web.ControllerHelper;
import java.beans.PropertyEditor;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.propertyeditors.CustomDateEditor;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.ServletRequestDataBinder;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/hframe/hfsecUser"})
public class HfsecUserController {
    private static final Logger logger = LoggerFactory.getLogger(HfsecUserController.class);
    @Resource
    private IHfsecUserSV iHfsecUserSV;

    @InitBinder
    protected void initBinder(HttpServletRequest request, ServletRequestDataBinder binder) throws Exception {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        CustomDateEditor editor = new CustomDateEditor((DateFormat)df, false);
        binder.registerCustomEditor(Date.class, (PropertyEditor)editor);
    }

    @RequestMapping(value={"/queryListByAjax.json"})
    @ResponseBody
    public ResultData list(@ModelAttribute(value="hfsecUser") HfsecUser hfsecUser, @ModelAttribute(value="example") HfsecUser_Example example, Pagination pagination) {
        logger.debug("request : {},{},{}", new Object[]{hfsecUser, example, pagination});
        try {
            ExampleUtils.parseExample((Object)hfsecUser, (Object)example);
            example.setLimitStart(pagination.getStartIndex());
            example.setLimitEnd(pagination.getEndIndex());
            List<HfsecUser> list = this.iHfsecUserSV.getHfsecUserListByExample(example);
            pagination.setTotalCount(this.iHfsecUserSV.getHfsecUserCountByExample(example));
            return ResultData.success().add("list", list).add("pagination", (Object)pagination);
        }
        catch (Exception e) {
            logger.error("error : ", (Throwable)e);
            return ResultData.error((ResultCode)ResultCode.ERROR);
        }
    }

    @RequestMapping(value={"/queryOneByAjax.json"})
    @ResponseBody
    public ResultData detail(@ModelAttribute(value="hfsecUser") HfsecUser hfsecUser) {
        logger.debug("request : {},{}", (Object)hfsecUser.getHfsecUserId(), (Object)hfsecUser);
        try {
            HfsecUser result = null;
            if (hfsecUser.getHfsecUserId() != null) {
                result = this.iHfsecUserSV.getHfsecUserByPK(hfsecUser.getHfsecUserId());
            } else {
                HfsecUser_Example example = (HfsecUser_Example)ExampleUtils.parseExample((Object)hfsecUser, HfsecUser_Example.class);
                List<HfsecUser> list = this.iHfsecUserSV.getHfsecUserListByExample(example);
                if (list != null && list.size() == 1) {
                    result = list.get(0);
                }
            }
            if (result != null) {
                return ResultData.success((Object)result);
            }
            return ResultData.error((ResultCode)ResultCode.RECODE_IS_NOT_EXISTS);
        }
        catch (Exception e) {
            logger.error("error : ", (Throwable)e);
            return ResultData.error((ResultCode)ResultCode.ERROR);
        }
    }

    @RequestMapping(value={"/searchOneByAjax.json"})
    @ResponseBody
    public ResultData search(@ModelAttribute(value=" hfsecUser") HfsecUser hfsecUser) {
        logger.debug("request : {}", (Object)hfsecUser);
        try {
            HfsecUser result = null;
            if (hfsecUser.getHfsecUserId() != null) {
                result = this.iHfsecUserSV.getHfsecUserByPK(hfsecUser.getHfsecUserId());
            } else {
                HfsecUser_Example example = (HfsecUser_Example)ExampleUtils.parseExample((Object)hfsecUser, HfsecUser_Example.class);
                example.setLimitStart(0);
                example.setLimitEnd(1);
                List<HfsecUser> list = this.iHfsecUserSV.getHfsecUserListByExample(example);
                if (list != null && list.size() > 0) {
                    result = list.get(0);
                }
            }
            if (result != null) {
                return ResultData.success((Object)result);
            }
            return ResultData.error((ResultCode)ResultCode.RECODE_IS_NOT_EXISTS);
        }
        catch (Exception e) {
            logger.error("error : ", (Throwable)e);
            return ResultData.error((ResultCode)ResultCode.ERROR);
        }
    }

    @RequestMapping(value={"/createByAjax.json"})
    @ResponseBody
    public ResultData create(@ModelAttribute(value="hfsecUser") HfsecUser hfsecUser) {
        logger.debug("request : {}", (Object)hfsecUser);
        try {
            ControllerHelper.setDefaultValue((Object)hfsecUser, (String)"hfsecUserId");
            int result = this.iHfsecUserSV.create(hfsecUser);
            if (result > 0) {
                return ResultData.success((Object)hfsecUser);
            }
        }
        catch (BusinessException e) {
            return e.result();
        }
        catch (Exception e) {
            logger.error("error : ", (Throwable)e);
            return ResultData.error((ResultCode)ResultCode.ERROR);
        }
        return ResultData.error((ResultCode)ResultCode.UNKNOW);
    }

    @RequestMapping(value={"/createsByAjax.json"})
    @ResponseBody
    public ResultData batchCreate(@RequestBody HfsecUser[] hfsecUsers) {
        logger.debug("request : {}", (Object[])hfsecUsers);
        try {
            ControllerHelper.setDefaultValue((Object[])hfsecUsers, (String)"hfsecUserId");
            ControllerHelper.reorderProperty((Object[])hfsecUsers);
            int result = this.iHfsecUserSV.batchOperate(hfsecUsers);
            if (result > 0) {
                return ResultData.success((Object)hfsecUsers);
            }
        }
        catch (BusinessException e) {
            return e.result();
        }
        catch (Exception e) {
            logger.error("error : ", (Throwable)e);
            return ResultData.error((ResultCode)ResultCode.ERROR);
        }
        return ResultData.error((ResultCode)ResultCode.UNKNOW);
    }

    @RequestMapping(value={"/updateByAjax.json"})
    @ResponseBody
    public ResultData update(@ModelAttribute(value="hfsecUser") HfsecUser hfsecUser) {
        logger.debug("request : {}", (Object)hfsecUser);
        try {
            ControllerHelper.setDefaultValue((Object)hfsecUser, (String)"hfsecUserId");
            int result = this.iHfsecUserSV.update(hfsecUser);
            if (result > 0) {
                return ResultData.success((Object)hfsecUser);
            }
        }
        catch (BusinessException e) {
            return e.result();
        }
        catch (Exception e) {
            logger.error("error : ", (Throwable)e);
            return ResultData.error((ResultCode)ResultCode.ERROR);
        }
        return ResultData.error((ResultCode)ResultCode.UNKNOW);
    }

    @RequestMapping(value={"/saveOrUpdateByAjax.json"})
    @ResponseBody
    public ResultData saveOrUpdate(@ModelAttribute(value="hfsecUser") HfsecUser hfsecUser) {
        logger.debug("request : {}", (Object)hfsecUser);
        try {
            ControllerHelper.setDefaultValue((Object)hfsecUser, (String)"hfsecUserId");
            int result = this.iHfsecUserSV.batchOperate(new HfsecUser[]{hfsecUser});
            if (result > 0) {
                return ResultData.success((Object)hfsecUser);
            }
        }
        catch (BusinessException e) {
            return e.result();
        }
        catch (Exception e) {
            logger.error("error : ", (Throwable)e);
            return ResultData.error((ResultCode)ResultCode.ERROR);
        }
        return ResultData.error((ResultCode)ResultCode.UNKNOW);
    }

    @RequestMapping(value={"/deleteByAjax.json"})
    @ResponseBody
    public ResultData delete(@ModelAttribute(value="hfsecUser") HfsecUser hfsecUser) {
        logger.debug("request : {}", (Object)hfsecUser);
        try {
            ControllerHelper.setDefaultValue((Object)hfsecUser, (String)"hfsecUserId");
            int result = this.iHfsecUserSV.delete(hfsecUser);
            if (result > 0) {
                return ResultData.success((Object)hfsecUser);
            }
            return ResultData.error((ResultCode)ResultCode.RECODE_IS_NOT_EXISTS);
        }
        catch (BusinessException e) {
            return e.result();
        }
        catch (Exception e) {
            logger.error("error : ", (Throwable)e);
            return ResultData.error((ResultCode)ResultCode.ERROR);
        }
    }

    public IHfsecUserSV getIHfsecUserSV() {
        return this.iHfsecUserSV;
    }

    public void setIHfsecUserSV(IHfsecUserSV iHfsecUserSV) {
        this.iHfsecUserSV = iHfsecUserSV;
    }
}

