/*
 * Decompiled with CFR 0.152.
 */
package com.hframe.controller;

import com.hframe.domain.model.HfusEntityStore;
import com.hframe.domain.model.HfusEntityStore_Example;
import com.hframe.service.interfaces.IHfusEntityStoreSV;
import com.hframework.beans.controller.Pagination;
import com.hframework.beans.controller.ResultCode;
import com.hframework.beans.controller.ResultData;
import com.hframework.beans.exceptions.BusinessException;
import com.hframework.common.util.ExampleUtils;
import com.hframework.web.ControllerHelper;
import java.beans.PropertyEditor;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.propertyeditors.CustomDateEditor;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.ServletRequestDataBinder;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/hframe/hfusEntityStore"})
public class HfusEntityStoreController {
    private static final Logger logger = LoggerFactory.getLogger(HfusEntityStoreController.class);
    @Resource
    private IHfusEntityStoreSV iHfusEntityStoreSV;

    @InitBinder
    protected void initBinder(HttpServletRequest request, ServletRequestDataBinder binder) throws Exception {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        CustomDateEditor editor = new CustomDateEditor((DateFormat)df, false);
        binder.registerCustomEditor(Date.class, (PropertyEditor)editor);
    }

    @RequestMapping(value={"/queryListByAjax.json"})
    @ResponseBody
    public ResultData list(@ModelAttribute(value="hfusEntityStore") HfusEntityStore hfusEntityStore, @ModelAttribute(value="example") HfusEntityStore_Example example, Pagination pagination) {
        logger.debug("request : {},{},{}", new Object[]{hfusEntityStore, example, pagination});
        try {
            ExampleUtils.parseExample((Object)hfusEntityStore, (Object)example);
            example.setLimitStart(pagination.getStartIndex());
            example.setLimitEnd(pagination.getEndIndex());
            List<HfusEntityStore> list = this.iHfusEntityStoreSV.getHfusEntityStoreListByExample(example);
            pagination.setTotalCount(this.iHfusEntityStoreSV.getHfusEntityStoreCountByExample(example));
            return ResultData.success().add("list", list).add("pagination", (Object)pagination);
        }
        catch (Exception e) {
            logger.error("error : ", (Throwable)e);
            return ResultData.error((ResultCode)ResultCode.ERROR);
        }
    }

    @RequestMapping(value={"/queryOneByAjax.json"})
    @ResponseBody
    public ResultData detail(@ModelAttribute(value="hfusEntityStore") HfusEntityStore hfusEntityStore) {
        logger.debug("request : {},{}", (Object)hfusEntityStore.getHfusEntityStoreId(), (Object)hfusEntityStore);
        try {
            HfusEntityStore result = null;
            if (hfusEntityStore.getHfusEntityStoreId() != null) {
                result = this.iHfusEntityStoreSV.getHfusEntityStoreByPK(hfusEntityStore.getHfusEntityStoreId());
            } else {
                HfusEntityStore_Example example = (HfusEntityStore_Example)ExampleUtils.parseExample((Object)hfusEntityStore, HfusEntityStore_Example.class);
                List<HfusEntityStore> list = this.iHfusEntityStoreSV.getHfusEntityStoreListByExample(example);
                if (list != null && list.size() == 1) {
                    result = list.get(0);
                }
            }
            if (result != null) {
                return ResultData.success((Object)result);
            }
            return ResultData.error((ResultCode)ResultCode.RECODE_IS_NOT_EXISTS);
        }
        catch (Exception e) {
            logger.error("error : ", (Throwable)e);
            return ResultData.error((ResultCode)ResultCode.ERROR);
        }
    }

    @RequestMapping(value={"/searchOneByAjax.json"})
    @ResponseBody
    public ResultData search(@ModelAttribute(value=" hfusEntityStore") HfusEntityStore hfusEntityStore) {
        logger.debug("request : {}", (Object)hfusEntityStore);
        try {
            HfusEntityStore result = null;
            if (hfusEntityStore.getHfusEntityStoreId() != null) {
                result = this.iHfusEntityStoreSV.getHfusEntityStoreByPK(hfusEntityStore.getHfusEntityStoreId());
            } else {
                HfusEntityStore_Example example = (HfusEntityStore_Example)ExampleUtils.parseExample((Object)hfusEntityStore, HfusEntityStore_Example.class);
                example.setLimitStart(0);
                example.setLimitEnd(1);
                List<HfusEntityStore> list = this.iHfusEntityStoreSV.getHfusEntityStoreListByExample(example);
                if (list != null && list.size() > 0) {
                    result = list.get(0);
                }
            }
            if (result != null) {
                return ResultData.success((Object)result);
            }
            return ResultData.error((ResultCode)ResultCode.RECODE_IS_NOT_EXISTS);
        }
        catch (Exception e) {
            logger.error("error : ", (Throwable)e);
            return ResultData.error((ResultCode)ResultCode.ERROR);
        }
    }

    @RequestMapping(value={"/createByAjax.json"})
    @ResponseBody
    public ResultData create(@ModelAttribute(value="hfusEntityStore") HfusEntityStore hfusEntityStore) {
        logger.debug("request : {}", (Object)hfusEntityStore);
        try {
            ControllerHelper.setDefaultValue((Object)hfusEntityStore, (String)"hfusEntityStoreId");
            int result = this.iHfusEntityStoreSV.create(hfusEntityStore);
            if (result > 0) {
                return ResultData.success((Object)hfusEntityStore);
            }
        }
        catch (BusinessException e) {
            return e.result();
        }
        catch (Exception e) {
            logger.error("error : ", (Throwable)e);
            return ResultData.error((ResultCode)ResultCode.ERROR);
        }
        return ResultData.error((ResultCode)ResultCode.UNKNOW);
    }

    @RequestMapping(value={"/createsByAjax.json"})
    @ResponseBody
    public ResultData batchCreate(@RequestBody HfusEntityStore[] hfusEntityStores) {
        logger.debug("request : {}", (Object[])hfusEntityStores);
        try {
            ControllerHelper.setDefaultValue((Object[])hfusEntityStores, (String)"hfusEntityStoreId");
            ControllerHelper.reorderProperty((Object[])hfusEntityStores);
            int result = this.iHfusEntityStoreSV.batchOperate(hfusEntityStores);
            if (result > 0) {
                return ResultData.success((Object)hfusEntityStores);
            }
        }
        catch (BusinessException e) {
            return e.result();
        }
        catch (Exception e) {
            logger.error("error : ", (Throwable)e);
            return ResultData.error((ResultCode)ResultCode.ERROR);
        }
        return ResultData.error((ResultCode)ResultCode.UNKNOW);
    }

    @RequestMapping(value={"/updateByAjax.json"})
    @ResponseBody
    public ResultData update(@ModelAttribute(value="hfusEntityStore") HfusEntityStore hfusEntityStore) {
        logger.debug("request : {}", (Object)hfusEntityStore);
        try {
            ControllerHelper.setDefaultValue((Object)hfusEntityStore, (String)"hfusEntityStoreId");
            int result = this.iHfusEntityStoreSV.update(hfusEntityStore);
            if (result > 0) {
                return ResultData.success((Object)hfusEntityStore);
            }
        }
        catch (BusinessException e) {
            return e.result();
        }
        catch (Exception e) {
            logger.error("error : ", (Throwable)e);
            return ResultData.error((ResultCode)ResultCode.ERROR);
        }
        return ResultData.error((ResultCode)ResultCode.UNKNOW);
    }

    @RequestMapping(value={"/saveOrUpdateByAjax.json"})
    @ResponseBody
    public ResultData saveOrUpdate(@ModelAttribute(value="hfusEntityStore") HfusEntityStore hfusEntityStore) {
        logger.debug("request : {}", (Object)hfusEntityStore);
        try {
            ControllerHelper.setDefaultValue((Object)hfusEntityStore, (String)"hfusEntityStoreId");
            int result = this.iHfusEntityStoreSV.batchOperate(new HfusEntityStore[]{hfusEntityStore});
            if (result > 0) {
                return ResultData.success((Object)hfusEntityStore);
            }
        }
        catch (BusinessException e) {
            return e.result();
        }
        catch (Exception e) {
            logger.error("error : ", (Throwable)e);
            return ResultData.error((ResultCode)ResultCode.ERROR);
        }
        return ResultData.error((ResultCode)ResultCode.UNKNOW);
    }

    @RequestMapping(value={"/deleteByAjax.json"})
    @ResponseBody
    public ResultData delete(@ModelAttribute(value="hfusEntityStore") HfusEntityStore hfusEntityStore) {
        logger.debug("request : {}", (Object)hfusEntityStore);
        try {
            ControllerHelper.setDefaultValue((Object)hfusEntityStore, (String)"hfusEntityStoreId");
            int result = this.iHfusEntityStoreSV.delete(hfusEntityStore);
            if (result > 0) {
                return ResultData.success((Object)hfusEntityStore);
            }
            return ResultData.error((ResultCode)ResultCode.RECODE_IS_NOT_EXISTS);
        }
        catch (BusinessException e) {
            return e.result();
        }
        catch (Exception e) {
            logger.error("error : ", (Throwable)e);
            return ResultData.error((ResultCode)ResultCode.ERROR);
        }
    }

    public IHfusEntityStoreSV getIHfusEntityStoreSV() {
        return this.iHfusEntityStoreSV;
    }

    public void setIHfusEntityStoreSV(IHfusEntityStoreSV iHfusEntityStoreSV) {
        this.iHfusEntityStoreSV = iHfusEntityStoreSV;
    }
}

