/*
 * Decompiled with CFR 0.152.
 */
package com.hframe.service.impl;

import com.google.common.collect.Lists;
import com.hframe.dao.HfsecMenuMapper;
import com.hframe.domain.model.HfsecMenu;
import com.hframe.domain.model.HfsecMenu_Example;
import com.hframe.service.interfaces.IHfsecMenuSV;
import com.hframework.common.util.ExampleUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(value="iHfsecMenuSV")
public class HfsecMenuSVImpl
implements IHfsecMenuSV {
    @Resource
    private HfsecMenuMapper hfsecMenuMapper;

    @Override
    public int create(HfsecMenu hfsecMenu) throws Exception {
        return this.hfsecMenuMapper.insertSelective(hfsecMenu);
    }

    @Override
    public int batchOperate(HfsecMenu[] hfsecMenus) throws Exception {
        int result = 0;
        if (hfsecMenus != null) {
            for (HfsecMenu hfsecMenu : hfsecMenus) {
                if (hfsecMenu.getHfsecMenuId() == null) {
                    result += this.create(hfsecMenu);
                    continue;
                }
                result += this.update(hfsecMenu);
            }
        }
        return result;
    }

    @Override
    public int update(HfsecMenu hfsecMenu) throws Exception {
        return this.hfsecMenuMapper.updateByPrimaryKeySelective(hfsecMenu);
    }

    @Override
    public int updateByExample(HfsecMenu hfsecMenu, HfsecMenu_Example example) throws Exception {
        return this.hfsecMenuMapper.updateByExampleSelective(hfsecMenu, example);
    }

    @Override
    public int delete(HfsecMenu hfsecMenu) throws Exception {
        return this.hfsecMenuMapper.deleteByPrimaryKey(hfsecMenu.getHfsecMenuId());
    }

    @Override
    public int delete(long hfsecMenuId) throws Exception {
        return this.hfsecMenuMapper.deleteByPrimaryKey(hfsecMenuId);
    }

    @Override
    public List<HfsecMenu> getHfsecMenuAll() throws Exception {
        return this.hfsecMenuMapper.selectByExample(new HfsecMenu_Example());
    }

    @Override
    public HfsecMenu getHfsecMenuByPK(long hfsecMenuId) throws Exception {
        return this.hfsecMenuMapper.selectByPrimaryKey(hfsecMenuId);
    }

    @Override
    public Map<Long, List<HfsecMenu>> getHfsecMenuTreeByParentId(HfsecMenu hfsecMenu, HfsecMenu_Example example) throws Exception {
        HashMap<Long, List<HfsecMenu>> result = new HashMap<Long, List<HfsecMenu>>();
        this.fillHfsecMenuTreeCascade(result, Lists.newArrayList((Object[])new Long[]{hfsecMenu.getParentHfsecMenuId() == null ? -1L : hfsecMenu.getParentHfsecMenuId()}), example);
        return result;
    }

    private void fillHfsecMenuTreeCascade(Map<Long, List<HfsecMenu>> result, List<Long> parentIds, HfsecMenu_Example templateExample) throws Exception {
        HfsecMenu_Example example;
        if (parentIds.size() == 0) {
            return;
        }
        if (templateExample == null) {
            templateExample = new HfsecMenu_Example();
        }
        if ((example = (HfsecMenu_Example)ExampleUtils.clone((Object)templateExample)).getOredCriteria() != null && example.getOredCriteria().size() > 0) {
            example.getOredCriteria().get(0).andParentHfsecMenuIdIn((List)parentIds);
        } else {
            example.createCriteria().andParentHfsecMenuIdIn((List)parentIds);
        }
        List<HfsecMenu> hfsecMenus = this.hfsecMenuMapper.selectByExample(example);
        if (hfsecMenus == null || hfsecMenus.size() == 0) {
            return;
        }
        if (parentIds.size() == 1) {
            result.put(parentIds.get(0), hfsecMenus);
        } else {
            for (HfsecMenu hfsecMenu : hfsecMenus) {
                Long parentId = hfsecMenu.getParentHfsecMenuId();
                if (!result.containsKey(parentId)) {
                    result.put(parentId, new ArrayList());
                }
                result.get(parentId).add(hfsecMenu);
            }
        }
        ArrayList<Long> subIds = new ArrayList<Long>();
        for (HfsecMenu hfsecMenu : hfsecMenus) {
            subIds.add(hfsecMenu.getHfsecMenuId());
        }
        this.fillHfsecMenuTreeCascade(result, subIds, templateExample);
    }

    @Override
    public List<HfsecMenu> getHfsecMenuListByParam(Map<String, Object> params) throws Exception {
        return null;
    }

    @Override
    public List<HfsecMenu> getHfsecMenuListByExample(HfsecMenu_Example example) throws Exception {
        return this.hfsecMenuMapper.selectByExample(example);
    }

    @Override
    public int getHfsecMenuCountByParam(Map<String, Object> params) throws Exception {
        return 0;
    }

    @Override
    public int getHfsecMenuCountByExample(HfsecMenu_Example example) throws Exception {
        return this.hfsecMenuMapper.countByExample(example);
    }

    public HfsecMenuMapper getHfsecMenuMapper() {
        return this.hfsecMenuMapper;
    }

    public void setHfsecMenuMapper(HfsecMenuMapper hfsecMenuMapper) {
        this.hfsecMenuMapper = hfsecMenuMapper;
    }
}

