/*
 * Decompiled with CFR 0.152.
 */
package com.hframe.controller;

import com.hframe.domain.model.HfmdEntityAttr;
import com.hframe.domain.model.HfmdEntityAttr_Example;
import com.hframe.service.interfaces.IHfmdEntityAttrSV;
import com.hframework.beans.controller.Pagination;
import com.hframework.beans.controller.ResultCode;
import com.hframework.beans.controller.ResultData;
import com.hframework.common.util.ExampleUtils;
import com.hframework.web.ControllerHelper;
import java.beans.PropertyEditor;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.propertyeditors.CustomDateEditor;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.ServletRequestDataBinder;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/hframe/hfmdEntityAttr"})
public class HfmdEntityAttrController {
    private static final Logger logger = LoggerFactory.getLogger(HfmdEntityAttrController.class);
    @Resource
    private IHfmdEntityAttrSV iHfmdEntityAttrSV;

    @InitBinder
    protected void initBinder(HttpServletRequest request, ServletRequestDataBinder binder) throws Exception {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        CustomDateEditor editor = new CustomDateEditor((DateFormat)df, false);
        binder.registerCustomEditor(Date.class, (PropertyEditor)editor);
    }

    @RequestMapping(value={"/queryListByAjax.json"})
    @ResponseBody
    public ResultData list(@ModelAttribute(value="hfmdEntityAttr") HfmdEntityAttr hfmdEntityAttr, @ModelAttribute(value="example") HfmdEntityAttr_Example example, Pagination pagination) {
        logger.debug("request : {},{},{}", new Object[]{hfmdEntityAttr, example, pagination});
        try {
            ExampleUtils.parseExample((Object)hfmdEntityAttr, (Object)example);
            example.setLimitStart(pagination.getStartIndex());
            example.setLimitEnd(pagination.getEndIndex());
            List<HfmdEntityAttr> list = this.iHfmdEntityAttrSV.getHfmdEntityAttrListByExample(example);
            pagination.setTotalCount(this.iHfmdEntityAttrSV.getHfmdEntityAttrCountByExample(example));
            return ResultData.success().add("list", list).add("pagination", (Object)pagination);
        }
        catch (Exception e) {
            logger.error("error : ", (Throwable)e);
            return ResultData.error((ResultCode)ResultCode.ERROR);
        }
    }

    @RequestMapping(value={"/queryOneByAjax.json"})
    @ResponseBody
    public ResultData detail(@ModelAttribute(value="hfmdEntityAttr") HfmdEntityAttr hfmdEntityAttr) {
        logger.debug("request : {},{}", (Object)hfmdEntityAttr.getHfmdEntityAttrId(), (Object)hfmdEntityAttr);
        try {
            HfmdEntityAttr result = this.iHfmdEntityAttrSV.getHfmdEntityAttrByPK(hfmdEntityAttr.getHfmdEntityAttrId());
            if (result != null) {
                return ResultData.success((Object)result);
            }
            return ResultData.error((ResultCode)ResultCode.RECODE_IS_NOT_EXISTS);
        }
        catch (Exception e) {
            logger.error("error : ", (Throwable)e);
            return ResultData.error((ResultCode)ResultCode.ERROR);
        }
    }

    @RequestMapping(value={"/createByAjax.json"})
    @ResponseBody
    public ResultData create(@ModelAttribute(value="hfmdEntityAttr") HfmdEntityAttr hfmdEntityAttr) {
        logger.debug("request : {}", (Object)hfmdEntityAttr);
        try {
            ControllerHelper.setDefaultValue((Object)hfmdEntityAttr, (String)"hfmdEntityAttrId");
            int result = this.iHfmdEntityAttrSV.create(hfmdEntityAttr);
            if (result > 0) {
                return ResultData.success((Object)hfmdEntityAttr);
            }
        }
        catch (Exception e) {
            logger.error("error : ", (Throwable)e);
            return ResultData.error((ResultCode)ResultCode.ERROR);
        }
        return ResultData.error((ResultCode)ResultCode.UNKNOW);
    }

    @RequestMapping(value={"/createsByAjax.json"})
    @ResponseBody
    public ResultData batchCreate(@RequestBody HfmdEntityAttr[] hfmdEntityAttrs) {
        logger.debug("request : {}", (Object[])hfmdEntityAttrs);
        try {
            ControllerHelper.setDefaultValue((Object[])hfmdEntityAttrs, (String)"hfmdEntityAttrId");
            ControllerHelper.reorderProperty((Object[])hfmdEntityAttrs);
            int result = this.iHfmdEntityAttrSV.batchOperate(hfmdEntityAttrs);
            if (result > 0) {
                return ResultData.success((Object)hfmdEntityAttrs);
            }
        }
        catch (Exception e) {
            logger.error("error : ", (Throwable)e);
            return ResultData.error((ResultCode)ResultCode.ERROR);
        }
        return ResultData.error((ResultCode)ResultCode.UNKNOW);
    }

    @RequestMapping(value={"/updateByAjax.json"})
    @ResponseBody
    public ResultData update(@ModelAttribute(value="hfmdEntityAttr") HfmdEntityAttr hfmdEntityAttr) {
        logger.debug("request : {}", (Object)hfmdEntityAttr);
        try {
            ControllerHelper.setDefaultValue((Object)hfmdEntityAttr, (String)"hfmdEntityAttrId");
            int result = this.iHfmdEntityAttrSV.update(hfmdEntityAttr);
            if (result > 0) {
                return ResultData.success((Object)hfmdEntityAttr);
            }
        }
        catch (Exception e) {
            logger.error("error : ", (Throwable)e);
            return ResultData.error((ResultCode)ResultCode.ERROR);
        }
        return ResultData.error((ResultCode)ResultCode.UNKNOW);
    }

    @RequestMapping(value={"/deleteByAjax.json"})
    @ResponseBody
    public ResultData delete(@ModelAttribute(value="hfmdEntityAttr") HfmdEntityAttr hfmdEntityAttr) {
        logger.debug("request : {}", (Object)hfmdEntityAttr);
        try {
            ControllerHelper.setDefaultValue((Object)hfmdEntityAttr, (String)"hfmdEntityAttrId");
            int result = this.iHfmdEntityAttrSV.delete(hfmdEntityAttr);
            if (result > 0) {
                return ResultData.success((Object)hfmdEntityAttr);
            }
            return ResultData.error((ResultCode)ResultCode.RECODE_IS_NOT_EXISTS);
        }
        catch (Exception e) {
            logger.error("error : ", (Throwable)e);
            return ResultData.error((ResultCode)ResultCode.ERROR);
        }
    }

    public IHfmdEntityAttrSV getIHfmdEntityAttrSV() {
        return this.iHfmdEntityAttrSV;
    }

    public void setIHfmdEntityAttrSV(IHfmdEntityAttrSV iHfmdEntityAttrSV) {
        this.iHfmdEntityAttrSV = iHfmdEntityAttrSV;
    }
}

