/*
 * Decompiled with CFR 0.152.
 */
package com.hframe.controller;

import com.hframe.domain.model.HfmdEntity;
import com.hframe.domain.model.HfmdEntity_Example;
import com.hframe.service.interfaces.IHfmdEntitySV;
import com.hframework.beans.controller.Pagination;
import com.hframework.beans.controller.ResultCode;
import com.hframework.beans.controller.ResultData;
import com.hframework.common.util.ExampleUtils;
import com.hframework.web.ControllerHelper;
import java.beans.PropertyEditor;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.propertyeditors.CustomDateEditor;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.ServletRequestDataBinder;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/hframe/hfmdEntity"})
public class HfmdEntityController {
    private static final Logger logger = LoggerFactory.getLogger(HfmdEntityController.class);
    @Resource
    private IHfmdEntitySV iHfmdEntitySV;

    @InitBinder
    protected void initBinder(HttpServletRequest request, ServletRequestDataBinder binder) throws Exception {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        CustomDateEditor editor = new CustomDateEditor((DateFormat)df, false);
        binder.registerCustomEditor(Date.class, (PropertyEditor)editor);
    }

    @RequestMapping(value={"/queryListByAjax.json"})
    @ResponseBody
    public ResultData list(@ModelAttribute(value="hfmdEntity") HfmdEntity hfmdEntity, @ModelAttribute(value="example") HfmdEntity_Example example, Pagination pagination) {
        logger.debug("request : {},{},{}", new Object[]{hfmdEntity, example, pagination});
        try {
            ExampleUtils.parseExample((Object)hfmdEntity, (Object)example);
            example.setLimitStart(pagination.getStartIndex());
            example.setLimitEnd(pagination.getEndIndex());
            List<HfmdEntity> list = this.iHfmdEntitySV.getHfmdEntityListByExample(example);
            pagination.setTotalCount(this.iHfmdEntitySV.getHfmdEntityCountByExample(example));
            return ResultData.success().add("list", list).add("pagination", (Object)pagination);
        }
        catch (Exception e) {
            logger.error("error : ", (Throwable)e);
            return ResultData.error((ResultCode)ResultCode.ERROR);
        }
    }

    @RequestMapping(value={"/queryOneByAjax.json"})
    @ResponseBody
    public ResultData detail(@ModelAttribute(value="hfmdEntity") HfmdEntity hfmdEntity) {
        logger.debug("request : {},{}", (Object)hfmdEntity.getHfmdEntityId(), (Object)hfmdEntity);
        try {
            HfmdEntity result = this.iHfmdEntitySV.getHfmdEntityByPK(hfmdEntity.getHfmdEntityId());
            if (result != null) {
                return ResultData.success((Object)result);
            }
            return ResultData.error((ResultCode)ResultCode.RECODE_IS_NOT_EXISTS);
        }
        catch (Exception e) {
            logger.error("error : ", (Throwable)e);
            return ResultData.error((ResultCode)ResultCode.ERROR);
        }
    }

    @RequestMapping(value={"/createByAjax.json"})
    @ResponseBody
    public ResultData create(@ModelAttribute(value="hfmdEntity") HfmdEntity hfmdEntity) {
        logger.debug("request : {}", (Object)hfmdEntity);
        try {
            ControllerHelper.setDefaultValue((Object)hfmdEntity, (String)"hfmdEntityId");
            int result = this.iHfmdEntitySV.create(hfmdEntity);
            if (result > 0) {
                return ResultData.success((Object)hfmdEntity);
            }
        }
        catch (Exception e) {
            logger.error("error : ", (Throwable)e);
            return ResultData.error((ResultCode)ResultCode.ERROR);
        }
        return ResultData.error((ResultCode)ResultCode.UNKNOW);
    }

    @RequestMapping(value={"/createsByAjax.json"})
    @ResponseBody
    public ResultData batchCreate(@RequestBody HfmdEntity[] hfmdEntitys) {
        logger.debug("request : {}", (Object[])hfmdEntitys);
        try {
            ControllerHelper.setDefaultValue((Object[])hfmdEntitys, (String)"hfmdEntityId");
            ControllerHelper.reorderProperty((Object[])hfmdEntitys);
            int result = this.iHfmdEntitySV.batchOperate(hfmdEntitys);
            if (result > 0) {
                return ResultData.success((Object)hfmdEntitys);
            }
        }
        catch (Exception e) {
            logger.error("error : ", (Throwable)e);
            return ResultData.error((ResultCode)ResultCode.ERROR);
        }
        return ResultData.error((ResultCode)ResultCode.UNKNOW);
    }

    @RequestMapping(value={"/updateByAjax.json"})
    @ResponseBody
    public ResultData update(@ModelAttribute(value="hfmdEntity") HfmdEntity hfmdEntity) {
        logger.debug("request : {}", (Object)hfmdEntity);
        try {
            ControllerHelper.setDefaultValue((Object)hfmdEntity, (String)"hfmdEntityId");
            int result = this.iHfmdEntitySV.update(hfmdEntity);
            if (result > 0) {
                return ResultData.success((Object)hfmdEntity);
            }
        }
        catch (Exception e) {
            logger.error("error : ", (Throwable)e);
            return ResultData.error((ResultCode)ResultCode.ERROR);
        }
        return ResultData.error((ResultCode)ResultCode.UNKNOW);
    }

    @RequestMapping(value={"/deleteByAjax.json"})
    @ResponseBody
    public ResultData delete(@ModelAttribute(value="hfmdEntity") HfmdEntity hfmdEntity) {
        logger.debug("request : {}", (Object)hfmdEntity);
        try {
            ControllerHelper.setDefaultValue((Object)hfmdEntity, (String)"hfmdEntityId");
            int result = this.iHfmdEntitySV.delete(hfmdEntity);
            if (result > 0) {
                return ResultData.success((Object)hfmdEntity);
            }
            return ResultData.error((ResultCode)ResultCode.RECODE_IS_NOT_EXISTS);
        }
        catch (Exception e) {
            logger.error("error : ", (Throwable)e);
            return ResultData.error((ResultCode)ResultCode.ERROR);
        }
    }

    public IHfmdEntitySV getIHfmdEntitySV() {
        return this.iHfmdEntitySV;
    }

    public void setIHfmdEntitySV(IHfmdEntitySV iHfmdEntitySV) {
        this.iHfmdEntitySV = iHfmdEntitySV;
    }
}

