/*
 * Decompiled with CFR 0.152.
 */
package com.hframe.controller;

import com.hframe.domain.model.HfsecOrganize;
import com.hframe.domain.model.HfsecOrganize_Example;
import com.hframe.service.interfaces.IHfsecOrganizeSV;
import com.hframework.beans.controller.Pagination;
import com.hframework.beans.controller.ResultCode;
import com.hframework.beans.controller.ResultData;
import com.hframework.beans.exceptions.BusinessException;
import com.hframework.common.util.ExampleUtils;
import com.hframework.web.ControllerHelper;
import java.beans.PropertyEditor;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.propertyeditors.CustomDateEditor;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.ServletRequestDataBinder;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/hframe/hfsecOrganize"})
public class HfsecOrganizeController {
    private static final Logger logger = LoggerFactory.getLogger(HfsecOrganizeController.class);
    @Resource
    private IHfsecOrganizeSV iHfsecOrganizeSV;

    @InitBinder
    protected void initBinder(HttpServletRequest request, ServletRequestDataBinder binder) throws Exception {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        CustomDateEditor editor = new CustomDateEditor((DateFormat)df, false);
        binder.registerCustomEditor(Date.class, (PropertyEditor)editor);
    }

    @RequestMapping(value={"/queryListByAjax.json"})
    @ResponseBody
    public ResultData list(@ModelAttribute(value="hfsecOrganize") HfsecOrganize hfsecOrganize, @ModelAttribute(value="example") HfsecOrganize_Example example, Pagination pagination) {
        logger.debug("request : {},{},{}", new Object[]{hfsecOrganize, example, pagination});
        try {
            ExampleUtils.parseExample((Object)hfsecOrganize, (Object)example);
            example.setLimitStart(pagination.getStartIndex());
            example.setLimitEnd(pagination.getEndIndex());
            List<HfsecOrganize> list = this.iHfsecOrganizeSV.getHfsecOrganizeListByExample(example);
            pagination.setTotalCount(this.iHfsecOrganizeSV.getHfsecOrganizeCountByExample(example));
            return ResultData.success().add("list", list).add("pagination", (Object)pagination);
        }
        catch (Exception e) {
            logger.error("error : ", (Throwable)e);
            return ResultData.error((ResultCode)ResultCode.ERROR);
        }
    }

    @RequestMapping(value={"/queryTeeByAjax.json"})
    @ResponseBody
    public ResultData tree(@ModelAttribute(value="hfsecOrganize") HfsecOrganize hfsecOrganize, @ModelAttribute(value="example") HfsecOrganize_Example example) {
        logger.debug("request : {},{}", (Object)hfsecOrganize, (Object)example);
        try {
            ExampleUtils.parseExample((Object)hfsecOrganize, (Object)example);
            Map<Long, List<HfsecOrganize>> treeMap = this.iHfsecOrganizeSV.getHfsecOrganizeTreeByParentId(hfsecOrganize, example);
            return ResultData.success(treeMap);
        }
        catch (Exception e) {
            logger.error("error : ", (Throwable)e);
            return ResultData.error((ResultCode)ResultCode.ERROR);
        }
    }

    @RequestMapping(value={"/queryOneByAjax.json"})
    @ResponseBody
    public ResultData detail(@ModelAttribute(value="hfsecOrganize") HfsecOrganize hfsecOrganize) {
        logger.debug("request : {},{}", (Object)hfsecOrganize.getHfsecOrganizeId(), (Object)hfsecOrganize);
        try {
            HfsecOrganize result = null;
            if (hfsecOrganize.getHfsecOrganizeId() != null) {
                result = this.iHfsecOrganizeSV.getHfsecOrganizeByPK(hfsecOrganize.getHfsecOrganizeId());
            } else {
                HfsecOrganize_Example example = (HfsecOrganize_Example)ExampleUtils.parseExample((Object)hfsecOrganize, HfsecOrganize_Example.class);
                List<HfsecOrganize> list = this.iHfsecOrganizeSV.getHfsecOrganizeListByExample(example);
                if (list != null && list.size() == 1) {
                    result = list.get(0);
                }
            }
            if (result != null) {
                return ResultData.success((Object)result);
            }
            return ResultData.error((ResultCode)ResultCode.RECODE_IS_NOT_EXISTS);
        }
        catch (Exception e) {
            logger.error("error : ", (Throwable)e);
            return ResultData.error((ResultCode)ResultCode.ERROR);
        }
    }

    @RequestMapping(value={"/searchOneByAjax.json"})
    @ResponseBody
    public ResultData search(@ModelAttribute(value=" hfsecOrganize") HfsecOrganize hfsecOrganize) {
        logger.debug("request : {}", (Object)hfsecOrganize);
        try {
            HfsecOrganize result = null;
            if (hfsecOrganize.getHfsecOrganizeId() != null) {
                result = this.iHfsecOrganizeSV.getHfsecOrganizeByPK(hfsecOrganize.getHfsecOrganizeId());
            } else {
                HfsecOrganize_Example example = (HfsecOrganize_Example)ExampleUtils.parseExample((Object)hfsecOrganize, HfsecOrganize_Example.class);
                example.setLimitStart(0);
                example.setLimitEnd(1);
                List<HfsecOrganize> list = this.iHfsecOrganizeSV.getHfsecOrganizeListByExample(example);
                if (list != null && list.size() > 0) {
                    result = list.get(0);
                }
            }
            if (result != null) {
                return ResultData.success((Object)result);
            }
            return ResultData.error((ResultCode)ResultCode.RECODE_IS_NOT_EXISTS);
        }
        catch (Exception e) {
            logger.error("error : ", (Throwable)e);
            return ResultData.error((ResultCode)ResultCode.ERROR);
        }
    }

    @RequestMapping(value={"/createByAjax.json"})
    @ResponseBody
    public ResultData create(@ModelAttribute(value="hfsecOrganize") HfsecOrganize hfsecOrganize) {
        logger.debug("request : {}", (Object)hfsecOrganize);
        try {
            ControllerHelper.setDefaultValue((Object)hfsecOrganize, (String)"hfsecOrganizeId");
            int result = this.iHfsecOrganizeSV.create(hfsecOrganize);
            if (result > 0) {
                return ResultData.success((Object)hfsecOrganize);
            }
        }
        catch (BusinessException e) {
            return e.result();
        }
        catch (Exception e) {
            logger.error("error : ", (Throwable)e);
            return ResultData.error((ResultCode)ResultCode.ERROR);
        }
        return ResultData.error((ResultCode)ResultCode.UNKNOW);
    }

    @RequestMapping(value={"/createsByAjax.json"})
    @ResponseBody
    public ResultData batchCreate(@RequestBody HfsecOrganize[] hfsecOrganizes) {
        logger.debug("request : {}", (Object[])hfsecOrganizes);
        try {
            ControllerHelper.setDefaultValue((Object[])hfsecOrganizes, (String)"hfsecOrganizeId");
            ControllerHelper.reorderProperty((Object[])hfsecOrganizes);
            int result = this.iHfsecOrganizeSV.batchOperate(hfsecOrganizes);
            if (result > 0) {
                return ResultData.success((Object)hfsecOrganizes);
            }
        }
        catch (BusinessException e) {
            return e.result();
        }
        catch (Exception e) {
            logger.error("error : ", (Throwable)e);
            return ResultData.error((ResultCode)ResultCode.ERROR);
        }
        return ResultData.error((ResultCode)ResultCode.UNKNOW);
    }

    @RequestMapping(value={"/updateByAjax.json"})
    @ResponseBody
    public ResultData update(@ModelAttribute(value="hfsecOrganize") HfsecOrganize hfsecOrganize) {
        logger.debug("request : {}", (Object)hfsecOrganize);
        try {
            ControllerHelper.setDefaultValue((Object)hfsecOrganize, (String)"hfsecOrganizeId");
            int result = this.iHfsecOrganizeSV.update(hfsecOrganize);
            if (result > 0) {
                return ResultData.success((Object)hfsecOrganize);
            }
        }
        catch (BusinessException e) {
            return e.result();
        }
        catch (Exception e) {
            logger.error("error : ", (Throwable)e);
            return ResultData.error((ResultCode)ResultCode.ERROR);
        }
        return ResultData.error((ResultCode)ResultCode.UNKNOW);
    }

    @RequestMapping(value={"/saveOrUpdateByAjax.json"})
    @ResponseBody
    public ResultData saveOrUpdate(@ModelAttribute(value="hfsecOrganize") HfsecOrganize hfsecOrganize) {
        logger.debug("request : {}", (Object)hfsecOrganize);
        try {
            ControllerHelper.setDefaultValue((Object)hfsecOrganize, (String)"hfsecOrganizeId");
            int result = this.iHfsecOrganizeSV.batchOperate(new HfsecOrganize[]{hfsecOrganize});
            if (result > 0) {
                return ResultData.success((Object)hfsecOrganize);
            }
        }
        catch (BusinessException e) {
            return e.result();
        }
        catch (Exception e) {
            logger.error("error : ", (Throwable)e);
            return ResultData.error((ResultCode)ResultCode.ERROR);
        }
        return ResultData.error((ResultCode)ResultCode.UNKNOW);
    }

    @RequestMapping(value={"/deleteByAjax.json"})
    @ResponseBody
    public ResultData delete(@ModelAttribute(value="hfsecOrganize") HfsecOrganize hfsecOrganize) {
        logger.debug("request : {}", (Object)hfsecOrganize);
        try {
            ControllerHelper.setDefaultValue((Object)hfsecOrganize, (String)"hfsecOrganizeId");
            int result = this.iHfsecOrganizeSV.delete(hfsecOrganize);
            if (result > 0) {
                return ResultData.success((Object)hfsecOrganize);
            }
            return ResultData.error((ResultCode)ResultCode.RECODE_IS_NOT_EXISTS);
        }
        catch (BusinessException e) {
            return e.result();
        }
        catch (Exception e) {
            logger.error("error : ", (Throwable)e);
            return ResultData.error((ResultCode)ResultCode.ERROR);
        }
    }

    public IHfsecOrganizeSV getIHfsecOrganizeSV() {
        return this.iHfsecOrganizeSV;
    }

    public void setIHfsecOrganizeSV(IHfsecOrganizeSV iHfsecOrganizeSV) {
        this.iHfsecOrganizeSV = iHfsecOrganizeSV;
    }
}

