/*
 * Copyright (c)  2018. houbinbin Inc.
 * api All rights reserved.
 */

package com.github.houbb.api.constant;

import com.github.houbb.api.version.V0;

import org.apiguardian.api.API;

/**
 * <p> maven 版本信息枚举 </p>
 *
 * <pre> Created: 2018/8/19 下午4:29  </pre>
 * <pre> Project: api  </pre>
 *
 * @author houbinbin
 */
@API(status = API.Status.EXPERIMENTAL, since = V0.V_0_0_4)
public final class MavenVersion {

    private MavenVersion() {
    }

    /**
     * 快照版本
     */
    public static final String SNAPSHOT = "Snapshot";

    /**
     * 内部测试版
     */
    public static final String ALPHA = "Alpha";

    /**
     * 测试改进版
     */
    public static final String BETA = "Beta";

    /**
     * 候选版本
     */
    public static final String RC = "RC";

    /**
     * 进本可用版本
     */
    public static final String GA = "GA";

    /**
     * 稳定版本
     */
    public static final String RELEASE = "Release";

}
