/*
 * Copyright (c)  2018. houbinbin Inc.
 * api All rights reserved.
 */

package com.github.houbb.api.constant;

import com.github.houbb.api.version.V0;

import org.apiguardian.api.API;

/**
 * <p> maven 版本信息 </p>
 *
 * <pre> Created: 2018/8/19 下午4:29  </pre>
 * <pre> Project: api  </pre>
 *
 * @author houbinbin
 */
@API(status = API.Status.EXPERIMENTAL, since = V0.V_0_0_4)
public enum MavenVersionEnum {

    /**
     * 快照版本
     */
    SNAPSHOT(MavenVersion.SNAPSHOT, "Snapshot"),
    /**
     * 内部测试版
     */
    ALPHA(MavenVersion.ALPHA, "Alpha"),
    /**
     * 测试改进版
     */
    BETA(MavenVersion.BETA, "Beta"),
    /**
     * 候选版本
     */
    RC(MavenVersion.RC, "Release Candidate"),
    /**
     * 进本可用版本
     */
    GA(MavenVersion.GA, "General Availability"),
    /**
     * 稳定版本
     */
    RELEASE(MavenVersion.RELEASE, "Release"),;

    MavenVersionEnum(String version, String label) {
        this.version = version;
        this.label = label;
    }

    /**
     * 版本
     */
    private final String version;

    /**
     * 标签
     */
    private final String label;

    public String getVersion() {
        return version;
    }

    public String getLabel() {
        return label;
    }
}
