/*
 * Copyright (c)  2018. houbinbin Inc.
 * api All rights reserved.
 */

package com.github.houbb.api.star;

import com.github.houbb.api.version.V0;

import org.apiguardian.api.API;

/**
 * <p> 星星枚举 </p>
 *
 * <pre> Created: 2018/8/17 上午9:21  </pre>
 * <pre> Project: api  </pre>
 *
 * @author houbinbin
 */
@API(status = API.Status.MAINTAINED, since = V0.V_0_0_2)
public enum StarEnum {

    /**
     * 1 颗星
     */
    S1(1, "☆"),

    /**
     * 2 颗星
     */
    S2(2, "★"),

    /**
     * 3 颗星
     */
    S3(3, "★☆"),

    /**
     * 4 颗星
     */
    S4(4, "★★"),

    /**
     * 5 颗星
     */
    S5(5, "★★☆"),

    /**
     * 6 颗星
     */
    S6(6, "★★★"),

    /**
     * 7 颗星
     */
    S7(7, "★★★☆"),

    /**
     * 8 颗星
     */
    S8(8, "★★★★"),

    /**
     * 9 颗星
     */
    S9(9, "★★★★☆"),

    /**
     * 10 颗星
     */
    S10(10, "★★★★★"),

    /**
     * 11 颗星
     */
    S11(11, "★★★★★☆"),

    /**
     * 12 颗星
     */
    S12(12, "★★★★★★"),

    /**
     * 13 颗星
     */
    S13(13, "★★★★★★☆"),

    /**
     * 14 颗星
     */
    S14(14, "★★★★★★★"),

    /**
     * 15 颗星
     */
    S15(15, "★★★★★★★☆"),

    /**
     * 16 颗星
     */
    S16(16, "★★★★★★★★"),

    /**
     * 17 颗星
     */
    S17(17, "★★★★★★★★☆"),

    /**
     * 18 颗星
     */
    S18(18, "★★★★★★★★★"),

    /**
     * 19 颗星
     */
    S19(19, "★★★★★★★★★☆"),

    /**
     * 20 颗星
     */
    S20(20, "★★★★★★★★★★"),;


    /**
     * 实心
     */
    public static final String SOLID_STAR = "★";

    /**
     * 空心
     */
    public static final String HOLLOW_STAR = "☆";

    StarEnum(int weight, String label) {
        this.weight = weight;
        this.label = label;
    }

    /**
     * 权重
     */
    private final int weight;

    /**
     * 标签
     */
    private final String label;

    /**
     * 获取权重
     * @return 权重
     */
    public int getWeight() {
        return weight;
    }

    /**
     * 获取标签
     * @return 标签
     */
    public String getLabel() {
        return label;
    }
}
