package com.github.houbb.encryption.api.dto.req;

import com.github.houbb.checksum.annotation.CheckField;
import com.github.houbb.checksum.annotation.CheckValue;
import org.hibernate.validator.constraints.NotBlank;

import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * @author binbin.hou
 * @since 1.0.0
 */
public class CommonRequest implements Serializable {

    /**
     * 系统标识
     */
    @NotBlank(message = "系统标识不可为空")
    @CheckField
    private String systemId;

    /**
     * 环境标识
     */
    @NotBlank(message = "环境标识不可为空")
    @CheckField
    private String envId;

    /**
     * 日志跟踪号
     */
    @NotBlank(message = "日志跟踪号不可为空")
    @CheckField
    private String traceId;

    /**
     * 请求时间
     */
    @NotNull(message = "请求时间不可为空")
    @CheckField
    private Long requestTime;

    /**
     * 签名
     */
    @NotNull(message = "签名不可为空")
    @CheckValue
    private String checksum;

    public String getSystemId() {
        return systemId;
    }

    public void setSystemId(String systemId) {
        this.systemId = systemId;
    }

    public String getTraceId() {
        return traceId;
    }

    public void setTraceId(String traceId) {
        this.traceId = traceId;
    }

    public Long getRequestTime() {
        return requestTime;
    }

    public void setRequestTime(Long requestTime) {
        this.requestTime = requestTime;
    }

    public String getChecksum() {
        return checksum;
    }

    public void setChecksum(String checksum) {
        this.checksum = checksum;
    }

    public String getEnvId() {
        return envId;
    }

    public void setEnvId(String envId) {
        this.envId = envId;
    }

    @Override
    public String toString() {
        return "EncryptCommonRequest{" +
                "systemId='" + systemId + '\'' +
                ", envId='" + envId + '\'' +
                ", traceId='" + traceId + '\'' +
                ", requestTime=" + requestTime +
                ", checksum='" + checksum + '\'' +
                '}';
    }

}
