package com.github.houbb.encryption.api.dto.req;

import com.github.houbb.checksum.annotation.CheckField;
import org.hibernate.validator.constraints.NotBlank;

/**
 * 银行卡号解密入参
 * @author binbin.hou
 * @since 1.0.0
 */
public class DecryptBankCardNumRequest extends CommonRequest {

    /**
     * 银行卡号密文
     */
    @NotBlank(message = "银行卡号密文不可为空")
    @CheckField
    private String bankCardNumCipher;

    public String getBankCardNumCipher() {
        return bankCardNumCipher;
    }

    public void setBankCardNumCipher(String bankCardNumCipher) {
        this.bankCardNumCipher = bankCardNumCipher;
    }

    @Override
    public String toString() {
        return "DecryptBankCardNumRequest{" +
                "bankCardNumCipher='" + bankCardNumCipher + '\'' +
                "} " + super.toString();
    }

}
