package com.github.houbb.encryption.api.dto.req;

import com.github.houbb.checksum.annotation.CheckField;
import org.hibernate.validator.constraints.NotBlank;

/**
 * 邮箱解密入参
 * @author binbin.hou
 * @since 1.0.0
 */
public class DecryptEmailRequest extends CommonRequest {

    /**
     * 邮箱密文
     */
    @NotBlank(message = "邮箱密文不可为空")
    @CheckField
    private String emailCipher;

    public String getEmailCipher() {
        return emailCipher;
    }

    public void setEmailCipher(String emailCipher) {
        this.emailCipher = emailCipher;
    }

    @Override
    public String toString() {
        return "DecryptEmailRequest{" +
                "emailCipher='" + emailCipher + '\'' +
                "} " + super.toString();
    }

}
