package com.github.houbb.encryption.api.dto.req;

import com.github.houbb.checksum.annotation.CheckField;
import org.hibernate.validator.constraints.NotBlank;

/**
 * 身份证解密入参
 * @author binbin.hou
 * @since 1.0.0
 */
public class DecryptIdCardRequest extends CommonRequest {

    /**
     * 身份证密文
     */
    @NotBlank(message = "身份证密文不可为空")
    @CheckField
    private String idCardCipher;

    public String getIdCardCipher() {
        return idCardCipher;
    }

    public void setIdCardCipher(String idCardCipher) {
        this.idCardCipher = idCardCipher;
    }

    @Override
    public String toString() {
        return "DecryptIdCardRequest{" +
                "idCardCipher='" + idCardCipher + '\'' +
                "} " + super.toString();
    }

}
