package com.github.houbb.encryption.api.dto.req;

import com.github.houbb.checksum.annotation.CheckField;
import org.hibernate.validator.constraints.NotBlank;

/**
 * 姓名解密入参
 * @author binbin.hou
 * @since 1.0.0
 */
public class DecryptNameRequest extends CommonRequest {

    /**
     * 姓名密文
     */
    @NotBlank(message = "姓名密文不可为空")
    @CheckField
    private String nameCipher;

    public String getNameCipher() {
        return nameCipher;
    }

    public void setNameCipher(String nameCipher) {
        this.nameCipher = nameCipher;
    }

    @Override
    public String toString() {
        return "DecryptNameRequest{" +
                "nameCipher='" + nameCipher + '\'' +
                "} " + super.toString();
    }

}
