package com.github.houbb.encryption.api.dto.req;

import com.github.houbb.checksum.annotation.CheckField;
import org.hibernate.validator.constraints.NotBlank;

/**
 * 手机号解密入参
 * @author binbin.hou
 * @since 1.0.0
 */
public class DecryptPhoneRequest extends CommonRequest {

    /**
     * 手机号密文
     */
    @NotBlank(message = "手机号密文不可为空")
    @CheckField
    private String phoneCipher;

    public String getPhoneCipher() {
        return phoneCipher;
    }

    public void setPhoneCipher(String phoneCipher) {
        this.phoneCipher = phoneCipher;
    }

    @Override
    public String toString() {
        return "DecryptPhoneRequest{" +
                "phoneCipher='" + phoneCipher + '\'' +
                "} " + super.toString();
    }

}
