package com.github.houbb.encryption.api.dto.req;

import com.github.houbb.checksum.annotation.CheckField;
import org.hibernate.validator.constraints.NotBlank;

/**
 * 银行卡号加密入参
 * @author binbin.hou
 * @since 1.0.0
 */
public class EncryptBankCardNumRequest extends CommonRequest {

    /**
     * 银行卡号
     */
    @NotBlank(message = "银行卡号不可为空")
    @CheckField
    private String bankCardNum;

    public String getBankCardNum() {
        return bankCardNum;
    }

    public void setBankCardNum(String bankCardNum) {
        this.bankCardNum = bankCardNum;
    }

    @Override
    public String toString() {
        return "EncryptBankCardNumRequest{" +
                "bankCardNum='" + bankCardNum + '\'' +
                "} " + super.toString();
    }

}
