package com.github.houbb.encryption.api.dto.req;

import com.github.houbb.checksum.annotation.CheckField;
import org.hibernate.validator.constraints.NotBlank;

/**
 * 邮箱加密入参
 * @author binbin.hou
 * @since 1.1.0
 */
public class EncryptEmailRequest extends CommonRequest {

    /**
     * 邮箱
     */
    @NotBlank(message = "邮箱不可为空")
    @CheckField
    private String email;

    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    @Override
    public String toString() {
        return "EncryptEmailRequest{" +
                "email='" + email + '\'' +
                "} " + super.toString();
    }

}
