package com.github.houbb.encryption.api.dto.req;

import com.github.houbb.checksum.annotation.CheckField;
import org.hibernate.validator.constraints.NotBlank;

/**
 * 身份证加密入参
 * @author binbin.hou
 * @since 1.0.0
 */
public class EncryptIdCardRequest extends CommonRequest {

    /**
     * 身份证
     */
    @NotBlank(message = "身份证不可为空")
    @CheckField
    private String idCard;

    public String getIdCard() {
        return idCard;
    }

    public void setIdCard(String idCard) {
        this.idCard = idCard;
    }

    @Override
    public String toString() {
        return "EncryptIdCardRequest{" +
                "idCard='" + idCard + '\'' +
                "} " + super.toString();
    }

}
