package com.github.houbb.encryption.api.dto.req;

import com.github.houbb.checksum.annotation.CheckField;
import org.hibernate.validator.constraints.NotBlank;

/**
 * 姓名加密入参
 * @author binbin.hou
 * @since 1.0.0
 */
public class EncryptNameRequest extends CommonRequest {

    /**
     * 姓名
     */
    @NotBlank(message = "姓名不可为空")
    @CheckField
    private String name;

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String toString() {
        return "EncryptNameRequest{" +
                "name='" + name + '\'' +
                "} " + super.toString();
    }

}
