package com.github.houbb.encryption.api.dto.req;

import com.github.houbb.checksum.annotation.CheckField;
import org.hibernate.validator.constraints.NotBlank;

/**
 * 手机号加密入参
 * @author binbin.hou
 * @since 1.0.0
 */
public class EncryptPhoneRequest extends CommonRequest {

    /**
     * 手机号
     */
    @NotBlank(message = "手机号不可为空")
    @CheckField
    private String phone;

    public String getPhone() {
        return phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    @Override
    public String toString() {
        return "EncryptPhoneRequest{" +
                "phone='" + phone + '\'' +
                "} " + super.toString();
    }

}
