package com.github.houbb.encryption.api.service;


import com.github.houbb.encryption.api.dto.req.*;
import com.github.houbb.encryption.api.dto.resp.*;

/**
 * 解密接口
 * @author binbin.hou
 * @since 1.0.0
 */
public interface DecryptFacade {

    /**
     * 姓名解密
     * @param request 入参
     * @return 结果
     */
    DecryptNameResponse decryptName(final DecryptNameRequest request);

    /**
     * 身份证解密
     * @param request 入参
     * @return 结果
     */
    DecryptIdCardResponse decryptIdCard(final DecryptIdCardRequest request);

    /**
     * 银行卡号解密
     * @param request 入参
     * @return 结果
     */
    DecryptBankCardNumResponse decryptBankCardNum(final DecryptBankCardNumRequest request);

    /**
     * 手机号解密
     * @param request 入参
     * @return 结果
     */
    DecryptPhoneResponse decryptPhone(final DecryptPhoneRequest request);

    /**
     * 邮箱解密
     * @param request 入参
     * @return 结果
     */
    DecryptEmailResponse decryptEmail(final DecryptEmailRequest request);

}
