package com.github.houbb.encryption.api.service;


import com.github.houbb.encryption.api.dto.req.*;
import com.github.houbb.encryption.api.dto.resp.*;

/**
 * 加密接口
 * @author binbin.hou
 * @since 1.0.0
 */
public interface EncryptFacade {

    /**
     * 姓名加密
     * @param request 入参
     * @return 结果
     */
    EncryptNameResponse encryptName(final EncryptNameRequest request);


    /**
     * 身份证加密
     * @param request 入参
     * @return 结果
     */
    EncryptIdCardResponse encryptIdCard(final EncryptIdCardRequest request);

    /**
     * 银行卡号加密
     * @param request 入参
     * @return 结果
     */
    EncryptBankCardNumResponse encryptBankCardNum(final EncryptBankCardNumRequest request);

    /**
     * 手机号加密
     * @param request 入参
     * @return 结果
     */
    EncryptPhoneResponse encryptPhone(final EncryptPhoneRequest request);

    /**
     * 邮箱加密
     * @param request 入参
     * @return 结果
     * @since 1.1.0
     */
    EncryptEmailResponse encryptEmail(final EncryptEmailRequest request);

}
