package com.github.houbb.monitor.client.java.core;

import com.github.houbb.hibernator.valid.util.ValidHelper;
import com.github.houbb.id.api.Id;
import com.github.houbb.monitor.client.api.request.component.MonitorLogItem;
import com.github.houbb.monitor.client.java.thread.MonitorServerPushThread;
import com.github.houbb.monitor.client.java.thread.MonitorServerPushThreadConfig;

import java.util.ArrayDeque;
import java.util.Queue;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

/**
 * 监控客户端
 * @since 1.0.0
 * @author dh
 */
public class MonitorClient {

    /**
     * 系统标识
     */
    private String systemId;

    /**
     * 服务地址
     */
    private String serverAddress;

    /**
     * 密码盐值
     */
    private String saltKey;

    /**
     * 日志跟踪号生成策略
     */
    private Id traceIdGenerator;

    /**
     * 环境标识
     */
    private String envId;

    /**
     * 最大批次
     */
    private int maxBatchSize;

    /**
     * 初始化延迟秒数
     * @since 1.0.0
     */
    private long initDelaySeconds;

    /**
     * 重复调度秒数
     * @since 1.0.0
     */
    private long periodSeconds;

    /**
     * 队列
     * @since 1.0.0
     */
    private final Queue<MonitorLogItem> itemQueue = new ArrayDeque<>();

    private final ScheduledExecutorService scheduledExecutorService = Executors.newSingleThreadScheduledExecutor();

    /**
     * 初始化
     * @since 1.0.0
     */
    public void init(){
        MonitorServerPushThreadConfig config = new MonitorServerPushThreadConfig();
        config.setQueue(itemQueue);
        config.setMaxBatchSize(maxBatchSize);
        config.setSaltKey(saltKey);
        config.setEnvId(envId);
        config.setTraceIdGenerator(traceIdGenerator);
        config.setSystemId(systemId);
        config.setServerAddress(serverAddress);

        final Runnable runnable = new MonitorServerPushThread(config);
        scheduledExecutorService.scheduleAtFixedRate(runnable, initDelaySeconds, periodSeconds, TimeUnit.SECONDS);
    }

    public String getSystemId() {
        return systemId;
    }

    public void setSystemId(String systemId) {
        this.systemId = systemId;
    }

    public String getServerAddress() {
        return serverAddress;
    }

    public void setServerAddress(String serverAddress) {
        this.serverAddress = serverAddress;
    }

    public String getSaltKey() {
        return saltKey;
    }

    public void setSaltKey(String saltKey) {
        this.saltKey = saltKey;
    }

    public Id getTraceIdGenerator() {
        return traceIdGenerator;
    }

    public void setTraceIdGenerator(Id traceIdGenerator) {
        this.traceIdGenerator = traceIdGenerator;
    }

    public String getEnvId() {
        return envId;
    }

    public void setEnvId(String envId) {
        this.envId = envId;
    }

    public int getMaxBatchSize() {
        return maxBatchSize;
    }

    public void setMaxBatchSize(int maxBatchSize) {
        this.maxBatchSize = maxBatchSize;
    }

    public long getInitDelaySeconds() {
        return initDelaySeconds;
    }

    public void setInitDelaySeconds(long initDelaySeconds) {
        this.initDelaySeconds = initDelaySeconds;
    }

    public long getPeriodSeconds() {
        return periodSeconds;
    }

    public void setPeriodSeconds(long periodSeconds) {
        this.periodSeconds = periodSeconds;
    }

    /**
     * 添加监控日志
     * @param monitorLogItem 监控日志
     * @since 1.0.0
     */
    public void add(final MonitorLogItem monitorLogItem) {
        ValidHelper.failFast(monitorLogItem);

        itemQueue.add(monitorLogItem);
    }

}
