package com.github.houbb.monitor.client.java.thread;

import com.github.houbb.id.api.Id;
import com.github.houbb.monitor.client.api.request.component.MonitorLogItem;

import java.util.Queue;

/**
 * 推送策略配置
 * @since 1.0.0
 * @author dh
 */
public class MonitorServerPushThreadConfig {

    private Queue<MonitorLogItem> queue;

    /**
     * 系统标识
     */
    private String systemId;

    /**
     * 服务地址
     */
    private String serverAddress;

    /**
     * 密码盐值
     */
    private String saltKey;

    /**
     * 日志跟踪号生成策略
     */
    private Id traceIdGenerator;

    /**
     * 环境标识
     */
    private String envId;

    /**
     * 每次推送的最大大小
     */
    private int maxBatchSize;

    public Queue<MonitorLogItem> getQueue() {
        return queue;
    }

    public void setQueue(Queue<MonitorLogItem> queue) {
        this.queue = queue;
    }

    public String getSystemId() {
        return systemId;
    }

    public void setSystemId(String systemId) {
        this.systemId = systemId;
    }

    public String getServerAddress() {
        return serverAddress;
    }

    public void setServerAddress(String serverAddress) {
        this.serverAddress = serverAddress;
    }

    public String getSaltKey() {
        return saltKey;
    }

    public void setSaltKey(String saltKey) {
        this.saltKey = saltKey;
    }

    public Id getTraceIdGenerator() {
        return traceIdGenerator;
    }

    public void setTraceIdGenerator(Id traceIdGenerator) {
        this.traceIdGenerator = traceIdGenerator;
    }

    public String getEnvId() {
        return envId;
    }

    public void setEnvId(String envId) {
        this.envId = envId;
    }

    public int getMaxBatchSize() {
        return maxBatchSize;
    }

    public void setMaxBatchSize(int maxBatchSize) {
        this.maxBatchSize = maxBatchSize;
    }
}
