/*
 * Decompiled with CFR 0.152.
 */
package no.uib.cipr.matrix.sparse;

import com.github.fommil.netlib.ARPACK;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import no.uib.cipr.matrix.DenseVector;
import no.uib.cipr.matrix.DenseVectorSub;
import no.uib.cipr.matrix.Matrix;
import org.netlib.util.doubleW;
import org.netlib.util.intW;

public class ArpackGen {
    private boolean computeOnlyEigenvalues;
    private final ARPACK arpack = ARPACK.getInstance();
    public static double tolerance = 1.0E-5;
    public static double convergedTolerance = 1.0;
    public static int maxIterations = 10000;
    private final Matrix matrix;

    public void setComputeOnlyEigenvalues(boolean computeOnlyEigenvalues) {
        this.computeOnlyEigenvalues = computeOnlyEigenvalues;
    }

    public ArpackGen(Matrix matrix) {
        if (!matrix.isSquare()) {
            throw new IllegalArgumentException("matrix must be square");
        }
        this.matrix = matrix;
        this.computeOnlyEigenvalues = true;
    }

    public Map<Double, DenseVectorSub> solve(int eigenvalues, Ritz ritz) {
        return this.solve(eigenvalues, ritz, tolerance);
    }

    public Map<Double, DenseVectorSub> solve(int eigenvalues, Ritz ritz, double tolerance) {
        return this.solve(eigenvalues, ritz, tolerance, 0);
    }

    public Map<Double, DenseVectorSub> solve(int eigenvalues, Ritz ritz, double tolerance, int ncvModification) {
        if (eigenvalues <= 0) {
            throw new IllegalArgumentException(String.valueOf(eigenvalues) + " <= 0");
        }
        if (eigenvalues > this.matrix.numColumns() - 2) {
            throw new IllegalArgumentException("NEV " + eigenvalues + " >= " + this.matrix.numColumns() + " - 2");
        }
        int n = this.matrix.numRows();
        intW nev = new intW(eigenvalues);
        int ncv = Math.min(2 + eigenvalues + ncvModification, n);
        String bmat = "I";
        String which = ritz.name();
        doubleW tol = new doubleW(tolerance);
        convergedTolerance = tolerance;
        intW info = new intW(0);
        int[] iparam = new int[11];
        iparam[0] = 1;
        iparam[2] = Math.max(maxIterations, n);
        iparam[4] = 1;
        iparam[6] = 1;
        iparam[7] = 1;
        intW ido = new intW(0);
        double[] resid = new double[n];
        double[] v = new double[n * ncv];
        double[] workd = new double[3 * n];
        double[] workl = new double[3 * ncv * ncv + 6 * ncv];
        int[] ipntr = new int[11];
        int i = 0;
        while (true) {
            ++i;
            this.arpack.dnaupd(ido, bmat, n, which, nev.val, tol, resid, ncv, v, n, iparam, ipntr, workd, workl, workl.length, info);
            if (ido.val == 99) {
                if (info.val != 1) break;
                tol.val *= 10.0;
                convergedTolerance = tol.val;
                return this.solve(eigenvalues, ritz, tol.val, ncvModification);
            }
            if (ido.val != -1 && ido.val != 1) {
                throw new IllegalStateException("ido = " + ido.val);
            }
            this.av(workd, ipntr[0] - 1, ipntr[1] - 1);
        }
        if (info.val != 0 && info.val != 1) {
            if (info.val == 3) {
                return this.solve(eigenvalues, ritz, tolerance, ncvModification + 1);
            }
            throw new IllegalStateException("info = " + info.val);
        }
        double[] dr = new double[nev.val + 1];
        double[] di = Arrays.copyOf(dr, dr.length);
        boolean[] select = new boolean[ncv];
        double[] z = Arrays.copyOfRange(v, 0, (nev.val + 1) * n);
        boolean computeRitzVectors = !this.computeOnlyEigenvalues;
        this.arpack.dneupd(computeRitzVectors, "P", select, dr, di, z, 1, 0.0, 0.0, workd, bmat, n, which, nev, tol.val, resid, ncv, v, n, iparam, ipntr, workd, workl, workl.length, info);
        if (info.val != 0) {
            throw new IllegalStateException("info = " + info.val);
        }
        int computed = iparam[4];
        TreeMap<Double, DenseVectorSub> solution = new TreeMap<Double, DenseVectorSub>(new Comparator<Double>(){

            @Override
            public int compare(Double o1, Double o2) {
                return Double.compare(o2, o1);
            }
        });
        DenseVector eigenvectors = new DenseVector(v, false);
        i = 0;
        while (i < computed) {
            double eigenvalue = Math.sqrt(Math.pow(dr[i], 2.0) + Math.pow(di[i], 2.0));
            DenseVectorSub eigenvector = new DenseVectorSub(eigenvectors, i * n, n);
            solution.put(eigenvalue, eigenvector);
            ++i;
        }
        return solution;
    }

    private void av(double[] work, int input_offset, int output_offset) {
        DenseVector w = new DenseVector(work, false);
        DenseVectorSub x = new DenseVectorSub(w, input_offset, this.matrix.numColumns());
        DenseVectorSub y = new DenseVectorSub(w, output_offset, this.matrix.numColumns());
        this.matrix.mult(x, y);
    }

    public static enum Ritz {
        LM,
        SM,
        LR,
        SR,
        LI,
        SI;

    }
}

