/*
 * Decompiled with CFR 0.152.
 */
package no.uib.cipr.matrix.sparse;

import no.uib.cipr.matrix.DenseMatrix;
import no.uib.cipr.matrix.DenseVector;
import no.uib.cipr.matrix.GivensRotation;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.UpperTriangDenseMatrix;
import no.uib.cipr.matrix.Vector;
import no.uib.cipr.matrix.sparse.AbstractIterativeSolver;
import no.uib.cipr.matrix.sparse.IterativeSolverNotConvergedException;

public class GMRES
extends AbstractIterativeSolver {
    private int restart;
    private Vector w;
    private Vector u;
    private Vector r;
    private Vector[] v;
    private DenseVector s;
    private DenseMatrix H;
    private GivensRotation[] rotation;

    public GMRES(Vector template) {
        this(template, 30);
    }

    public GMRES(Vector template, int restart) {
        this.w = template.copy();
        this.u = template.copy();
        this.r = template.copy();
        this.setRestart(restart);
    }

    public void setRestart(int restart) {
        this.restart = restart;
        if (restart <= 0) {
            throw new IllegalArgumentException("restart must be a positive integer");
        }
        this.s = new DenseVector(restart + 1);
        this.H = new DenseMatrix(restart + 1, restart);
        this.rotation = new GivensRotation[restart + 1];
        this.v = new Vector[restart + 1];
        int i = 0;
        while (i < this.v.length) {
            this.v[i] = this.r.copy().zero();
            ++i;
        }
    }

    @Override
    public Vector solve(Matrix A, Vector b, Vector x) throws IterativeSolverNotConvergedException {
        this.checkSizes(A, b, x);
        A.multAdd(-1.0, x, this.u.set(b));
        this.M.apply(this.u, this.r);
        double normr = this.r.norm(Vector.Norm.Two);
        this.M.apply(b, this.u);
        this.iter.setFirst();
        while (!this.iter.converged(this.r, x)) {
            this.v[0].set(1.0 / normr, this.r);
            this.s.zero().set(0, normr);
            int i = 0;
            while (i < this.restart && !this.iter.converged(Math.abs(this.s.get(i)))) {
                A.mult(this.v[i], this.u);
                this.M.apply(this.u, this.w);
                int k = 0;
                while (k <= i) {
                    this.H.set(k, i, this.w.dot(this.v[k]));
                    this.w.add(-this.H.get(k, i), this.v[k]);
                    ++k;
                }
                this.H.set(i + 1, i, this.w.norm(Vector.Norm.Two));
                this.v[i + 1].set(1.0 / this.H.get(i + 1, i), this.w);
                k = 0;
                while (k < i) {
                    this.rotation[k].apply(this.H, i, k, k + 1);
                    ++k;
                }
                this.rotation[i] = new GivensRotation(this.H.get(i, i), this.H.get(i + 1, i));
                this.rotation[i].apply(this.H, i, i, i + 1);
                this.rotation[i].apply(this.s, i, i + 1);
                ++i;
                this.iter.next();
            }
            new UpperTriangDenseMatrix((Matrix)this.H, i, false).solve(this.s, this.s);
            int j = 0;
            while (j < i) {
                x.add(this.s.get(j), this.v[j]);
                ++j;
            }
            A.multAdd(-1.0, x, this.u.set(b));
            this.M.apply(this.u, this.r);
            normr = this.r.norm(Vector.Norm.Two);
            this.iter.next();
        }
        return x;
    }
}

