/*
 * Decompiled with CFR 0.152.
 */
package io.itit.itf.okhttp;

import io.itit.itf.okhttp.HttpClient;
import io.itit.itf.okhttp.ssl.X509TrustManagerImpl;
import java.net.Proxy;
import java.net.ProxySelector;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.net.SocketFactory;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.X509TrustManager;
import okhttp3.Authenticator;
import okhttp3.Cache;
import okhttp3.CertificatePinner;
import okhttp3.ConnectionPool;
import okhttp3.ConnectionSpec;
import okhttp3.CookieJar;
import okhttp3.Dispatcher;
import okhttp3.Dns;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Protocol;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FastHttpClientBuilder {
    private static Logger logger = LoggerFactory.getLogger(FastHttpClientBuilder.class);
    private OkHttpClient.Builder builder;

    public FastHttpClientBuilder() {
        this.builder = new OkHttpClient.Builder();
    }

    public FastHttpClientBuilder(OkHttpClient okHttpClient) {
        this.builder = okHttpClient.newBuilder();
    }

    public FastHttpClientBuilder connectTimeout(long timeout, TimeUnit unit) {
        this.builder.connectTimeout(timeout, unit);
        return this;
    }

    public FastHttpClientBuilder readTimeout(long timeout, TimeUnit unit) {
        this.builder.readTimeout(timeout, unit);
        return this;
    }

    public FastHttpClientBuilder writeTimeout(long timeout, TimeUnit unit) {
        this.builder.writeTimeout(timeout, unit);
        return this;
    }

    public FastHttpClientBuilder pingInterval(long interval, TimeUnit unit) {
        this.builder.pingInterval(interval, unit);
        return this;
    }

    public FastHttpClientBuilder proxy(Proxy proxy) {
        this.builder.proxy(proxy);
        return this;
    }

    public FastHttpClientBuilder proxySelector(ProxySelector proxySelector) {
        this.builder.proxySelector(proxySelector);
        return this;
    }

    public FastHttpClientBuilder cookieJar(CookieJar cookieJar) {
        this.builder.cookieJar(cookieJar);
        return this;
    }

    public FastHttpClientBuilder cache(Cache cache) {
        this.builder.cache(cache);
        return this;
    }

    public FastHttpClientBuilder dns(Dns dns) {
        this.builder.dns(dns);
        return this;
    }

    public FastHttpClientBuilder socketFactory(SocketFactory socketFactory) {
        this.builder.socketFactory(socketFactory);
        return this;
    }

    public FastHttpClientBuilder sslSocketFactory(SSLSocketFactory sslSocketFactory) {
        this.builder.sslSocketFactory(sslSocketFactory);
        return this;
    }

    public FastHttpClientBuilder sslSocketFactory(SSLSocketFactory sslSocketFactory, X509TrustManager trustManager) {
        this.builder.sslSocketFactory(sslSocketFactory, trustManager);
        return this;
    }

    public FastHttpClientBuilder hostnameVerifier(HostnameVerifier hostnameVerifier) {
        this.builder.hostnameVerifier(hostnameVerifier);
        return this;
    }

    public FastHttpClientBuilder certificatePinner(CertificatePinner certificatePinner) {
        this.builder.certificatePinner(certificatePinner);
        return this;
    }

    public FastHttpClientBuilder authenticator(Authenticator authenticator) {
        this.builder.authenticator(authenticator);
        return this;
    }

    public FastHttpClientBuilder proxyAuthenticator(Authenticator proxyAuthenticator) {
        this.builder.proxyAuthenticator(proxyAuthenticator);
        return this;
    }

    public FastHttpClientBuilder connectionPool(ConnectionPool connectionPool) {
        this.builder.connectionPool(connectionPool);
        return this;
    }

    public FastHttpClientBuilder followSslRedirects(boolean followProtocolRedirects) {
        this.builder.followSslRedirects(followProtocolRedirects);
        return this;
    }

    public FastHttpClientBuilder followRedirects(boolean followRedirects) {
        this.builder.followRedirects(followRedirects);
        return this;
    }

    public FastHttpClientBuilder retryOnConnectionFailure(boolean retryOnConnectionFailure) {
        this.builder.retryOnConnectionFailure(retryOnConnectionFailure);
        return this;
    }

    public FastHttpClientBuilder dispatcher(Dispatcher dispatcher) {
        this.builder.dispatcher(dispatcher);
        return this;
    }

    public FastHttpClientBuilder protocols(List<Protocol> protocols) {
        this.builder.protocols(protocols);
        return this;
    }

    public FastHttpClientBuilder connectionSpecs(List<ConnectionSpec> connectionSpecs) {
        this.builder.connectionSpecs(connectionSpecs);
        return this;
    }

    public FastHttpClientBuilder addInterceptor(Interceptor interceptor) {
        this.builder.addInterceptor(interceptor);
        return this;
    }

    public FastHttpClientBuilder addNetworkInterceptor(Interceptor interceptor) {
        this.builder.addNetworkInterceptor(interceptor);
        return this;
    }

    public OkHttpClient.Builder getBuilder() {
        return this.builder;
    }

    public FastHttpClientBuilder sslContext(SSLContext sslContext) {
        SSLSocketFactory sslSocketFactory = null;
        X509TrustManagerImpl trustManager = new X509TrustManagerImpl();
        try {
            sslSocketFactory = sslContext.getSocketFactory();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        this.builder.sslSocketFactory(sslSocketFactory, (X509TrustManager)trustManager).hostnameVerifier(new HostnameVerifier(){

            @Override
            public boolean verify(String hostname, SSLSession session) {
                return true;
            }
        });
        return this;
    }

    public HttpClient build() {
        HttpClient httpClient = new HttpClient(this.builder.build());
        return httpClient;
    }
}

