/*
 * Decompiled with CFR 0.152.
 */
package io.itit.itf.okhttp.callback;

import io.itit.itf.okhttp.Response;
import io.itit.itf.okhttp.callback.Callback;
import io.itit.itf.okhttp.util.FileUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import okhttp3.Call;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DownloadFileCallback
extends Callback {
    public static Logger logger = LoggerFactory.getLogger(DownloadFileCallback.class);
    private String fileAbsolutePath;

    public DownloadFileCallback() {
    }

    public DownloadFileCallback(String fileAbsolutePath) {
        this.fileAbsolutePath = fileAbsolutePath;
    }

    @Override
    public void onResponse(Call call, Response response, String id) {
        try {
            if (this.fileAbsolutePath != null && this.fileAbsolutePath.length() > 0) {
                File file = new File(this.fileAbsolutePath);
                FileUtil.saveContent(response.body().bytes(), file);
                this.onSuccess(call, file, id);
            } else {
                this.onSuccess(call, response.body().byteStream(), id);
            }
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public void onSuccess(Call call, File file, String id) {
    }

    public void onSuccess(Call call, InputStream fileStream, String id) {
    }
}

