/*
 * Decompiled with CFR 0.152.
 */
package io.itit.itf.okhttp;

import io.itit.itf.okhttp.RequestCall;
import java.util.LinkedHashMap;
import java.util.Map;
import okhttp3.OkHttpClient;

public abstract class OkHttpRequestBuilder<T extends OkHttpRequestBuilder> {
    protected OkHttpClient httpClient;
    protected String url;
    protected Object tag;
    protected Map<String, String> headers;
    protected Map<String, String> params;
    protected int id;

    public OkHttpRequestBuilder(OkHttpClient httpClient) {
        this.httpClient = httpClient;
        this.headers = new LinkedHashMap<String, String>();
        this.params = new LinkedHashMap<String, String>();
    }

    public T id(int id) {
        this.id = id;
        return (T)this;
    }

    public T url(String url) {
        this.url = url;
        return (T)this;
    }

    public T tag(Object tag) {
        this.tag = tag;
        return (T)this;
    }

    public T headers(Map<String, String> headers) {
        this.headers = headers;
        return (T)this;
    }

    public T addHeader(String key, String val) {
        this.headers.put(key, val);
        return (T)this;
    }

    public abstract RequestCall build();
}

