/*
 * Decompiled with CFR 0.152.
 */
package io.itit.itf.okhttp;

import io.itit.itf.okhttp.FastHttpClientBuilder;
import io.itit.itf.okhttp.GetBuilder;
import io.itit.itf.okhttp.HttpClient;
import io.itit.itf.okhttp.PostBuilder;
import io.itit.itf.okhttp.PutBuilder;
import io.itit.itf.okhttp.ssl.X509TrustManagerImpl;
import java.security.SecureRandom;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import okhttp3.OkHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FastHttpClient {
    public static Logger logger = LoggerFactory.getLogger(FastHttpClient.class);
    public static final String VERSION = "1.5";
    private static HttpClient httpClient = new HttpClient(FastHttpClient.getDefaultOkHttpClient());

    private static OkHttpClient getDefaultOkHttpClient() {
        OkHttpClient.Builder builder = new OkHttpClient().newBuilder();
        X509TrustManagerImpl trustManager = new X509TrustManagerImpl();
        SSLSocketFactory sslSocketFactory = null;
        try {
            SSLContext sslContext = SSLContext.getInstance("SSL");
            sslContext.init(null, new TrustManager[]{trustManager}, new SecureRandom());
            sslSocketFactory = sslContext.getSocketFactory();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return builder.sslSocketFactory(sslSocketFactory, (X509TrustManager)trustManager).hostnameVerifier(new HostnameVerifier(){

            @Override
            public boolean verify(String hostname, SSLSession session) {
                return true;
            }
        }).build();
    }

    public static FastHttpClientBuilder newBuilder() {
        return new FastHttpClientBuilder(httpClient.getOkHttpClient());
    }

    public static FastHttpClientBuilder newBuilder(OkHttpClient client) {
        return new FastHttpClientBuilder(client);
    }

    public static GetBuilder get() {
        return httpClient.get();
    }

    public static PostBuilder post() {
        return httpClient.post();
    }

    public static PutBuilder put() {
        return httpClient.put();
    }
}

