/*
 * Decompiled with CFR 0.152.
 */
package io.itit.itf.okhttp;

import io.itit.itf.okhttp.OkHttpRequest;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.FileNameMap;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.List;
import java.util.Map;
import okhttp3.FormBody;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.Request;
import okhttp3.RequestBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PostRequest
extends OkHttpRequest {
    public static Logger logger = LoggerFactory.getLogger(PostRequest.class);

    public PostRequest(String url, Object tag, Map<String, String> params, Map<String, String> headers, List<FileInfo> fileInfos, String postBody, MultipartBody multipartBody, int id) {
        super(url, tag, params, headers, fileInfos, postBody, multipartBody, id);
    }

    public PostRequest(String url, Object tag, Map<String, String> params, Map<String, String> encodeParams, Map<String, String> headers, List<FileInfo> fileInfos, String postBody, MultipartBody multipartBody, int id) {
        super(url, tag, params, encodeParams, headers, fileInfos, postBody, multipartBody, id);
    }

    @Override
    protected RequestBody buildRequestBody() {
        if (this.multipartBody != null) {
            return this.multipartBody;
        }
        if (this.fileInfos != null && this.fileInfos.size() > 0) {
            MultipartBody.Builder builder = new MultipartBody.Builder().setType(MultipartBody.FORM);
            this.addParams(builder);
            this.fileInfos.forEach(fileInfo -> {
                RequestBody fileBody = null;
                fileBody = fileInfo.file != null ? RequestBody.create((MediaType)MediaType.parse((String)"application/octet-stream"), (File)fileInfo.file) : RequestBody.create((MediaType)MediaType.parse((String)PostRequest.getMimeType(fileInfo.fileName)), (byte[])fileInfo.fileContent);
                builder.addFormDataPart(fileInfo.partName, fileInfo.fileName, fileBody);
            });
            if (this.body != null && this.body.length() > 0) {
                builder.addPart(RequestBody.create((MediaType)MultipartBody.FORM, (String)this.body));
            }
            return builder.build();
        }
        if (this.body != null && this.body.length() > 0) {
            MediaType mediaType = null;
            mediaType = this.headers.containsKey("Content-Type") ? MediaType.parse((String)((String)this.headers.get("Content-Type"))) : MediaType.parse((String)"text/plain;charset=utf-8");
            return RequestBody.create((MediaType)mediaType, (String)this.body);
        }
        FormBody.Builder builder = new FormBody.Builder();
        this.addParams(builder);
        FormBody formBody = builder.build();
        return formBody;
    }

    @Override
    protected Request buildRequest(RequestBody requestBody) {
        return this.builder.post(requestBody).build();
    }

    private void addParams(FormBody.Builder builder) {
        if (this.params != null) {
            this.params.forEach((k, v) -> builder.add(k, v));
        }
        if (this.encodedParams != null) {
            this.encodedParams.forEach((k, v) -> builder.addEncoded(k, v));
        }
    }

    private void addParams(MultipartBody.Builder builder) {
        if (this.params != null && !this.params.isEmpty()) {
            this.params.forEach((k, v) -> builder.addPart(Headers.of((String[])new String[]{"Content-Disposition", "form-data; name=\"" + k + "\""}), RequestBody.create(null, (String)v)));
        }
    }

    public static String getMimeType(String path) {
        FileNameMap fileNameMap = URLConnection.getFileNameMap();
        String contentTypeFor = null;
        try {
            contentTypeFor = fileNameMap.getContentTypeFor(URLEncoder.encode(path, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        if (contentTypeFor == null) {
            contentTypeFor = "application/octet-stream";
        }
        return contentTypeFor;
    }

    public static class FileInfo {
        public String partName;
        public String fileName;
        public byte[] fileContent;
        public File file;
    }
}

