/*
 * Decompiled with CFR 0.152.
 */
package io.itit.itf.okhttp;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import okhttp3.Handshake;
import okhttp3.Headers;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.ResponseBody;

public class Response {
    private okhttp3.Response response;

    public Response(okhttp3.Response response) {
        this.response = response;
    }

    public Request request() {
        return this.response.request();
    }

    public Protocol protocol() {
        return this.response.protocol();
    }

    public int code() {
        return this.response.code();
    }

    public boolean isSuccessful() {
        return this.response.isSuccessful();
    }

    public String message() {
        return this.response.message();
    }

    public Handshake handshake() {
        return this.response.handshake();
    }

    public List<String> headers(String name) {
        return this.response.headers(name);
    }

    public String header(String name) {
        return this.response.header(name, null);
    }

    public String header(String name, String defaultValue) {
        return this.response.header(name, defaultValue);
    }

    public Headers headers() {
        return this.response.headers();
    }

    public ResponseBody peekBody(long byteCount) throws IOException {
        return this.response.peekBody(byteCount);
    }

    public ResponseBody body() {
        return this.response.body();
    }

    public final String string() throws IOException {
        return this.body().string();
    }

    public final String string(String charset) throws IOException {
        return new String(this.body().bytes(), charset);
    }

    public final byte[] bytes() throws IOException {
        return this.body().bytes();
    }

    public final InputStream byteStream() {
        return this.body().source().inputStream();
    }

    public okhttp3.Response getResponse() {
        return this.response;
    }
}

