/*
 * Decompiled with CFR 0.152.
 */
package io.itit.itf.okhttp.util;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class ClassUtils {
    public static Map<String, String> objectToMap(Object obj) {
        HashMap<String, String> map = new HashMap<String, String>();
        List<Field> fields = ClassUtils.getFieldList(obj.getClass());
        for (Field field : fields) {
            int mod = field.getModifiers();
            if (Modifier.isStatic(mod) || Modifier.isFinal(mod)) continue;
            field.setAccessible(true);
            try {
                Object value = field.get(obj);
                if (value == null) continue;
                map.put(field.getName(), value.toString());
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        return map;
    }

    public static List<Field> getFieldList(Class<?> clazz) {
        ArrayList<Field> fields = new ArrayList<Field>();
        HashSet<String> filedNames = new HashSet<String>();
        for (Class<?> c = clazz; c != Object.class; c = c.getSuperclass()) {
            try {
                Field[] list;
                for (Field field : list = c.getDeclaredFields()) {
                    String name = field.getName();
                    if (filedNames.contains(name)) continue;
                    filedNames.add(field.getName());
                    fields.add(field);
                }
                continue;
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        return fields;
    }
}

