/*
 * Decompiled with CFR 0.152.
 */
package io.itit.itf.okhttp.util;

import io.itit.itf.okhttp.util.IOUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;

public class FileUtil {
    public static String getContent(String filePath) throws IOException {
        return FileUtil.getContent(new File(filePath));
    }

    public static String getContent(File file) throws IOException {
        return new String(Files.readAllBytes(file.toPath()), StandardCharsets.UTF_8);
    }

    public static byte[] getBytes(String filePath) throws IOException {
        return Files.readAllBytes(new File(filePath).toPath());
    }

    public static void saveContent(String content, File file) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(file);
             ByteArrayInputStream bis = new ByteArrayInputStream(content.getBytes());){
            FileUtil.copy(bis, fos);
        }
    }

    public static void saveContent(InputStream is, File file) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(file);){
            IOUtil.copy(is, fos);
        }
    }

    public static void saveContent(byte[] bb, File file) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(file);
             ByteArrayInputStream bis = new ByteArrayInputStream(bb);){
            FileUtil.copy(bis, fos);
        }
    }

    public static long copy(InputStream input, OutputStream output) throws IOException {
        byte[] buffer = new byte[4096];
        long count = 0L;
        int n = 0;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
            count += (long)n;
        }
        return count;
    }
}

