/*
 * Decompiled with CFR 0.152.
 */
package io.itit.itf.okhttp;

import io.itit.itf.okhttp.OkHttpRequestBuilder;
import io.itit.itf.okhttp.PostRequest;
import io.itit.itf.okhttp.RequestCall;
import java.io.File;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;

public class PostBuilder
extends OkHttpRequestBuilder<PostBuilder> {
    private List<PostRequest.FileInfo> fileInfos = new ArrayList<PostRequest.FileInfo>();
    private String postBody;
    private MultipartBody multipartBody;

    public PostBuilder(OkHttpClient httpClient) {
        super(httpClient);
    }

    @Override
    public RequestCall build() {
        return new PostRequest(this.url, this.tag, this.params, this.encodedParams, this.headers, this.fileInfos, this.postBody, this.multipartBody, this.id).build(this.httpClient);
    }

    public PostBuilder body(String postBody) {
        this.postBody = postBody;
        return this;
    }

    public PostBuilder multipartBody(MultipartBody multipartBody) {
        this.multipartBody = multipartBody;
        return this;
    }

    public PostBuilder addFile(String partName, String fileName, byte[] content) {
        PostRequest.FileInfo fileInfo = new PostRequest.FileInfo();
        fileInfo.partName = partName;
        fileInfo.fileName = fileName;
        fileInfo.fileContent = content;
        this.fileInfos.add(fileInfo);
        return this;
    }

    public PostBuilder addFile(String partName, String fileName, InputStream is) {
        PostRequest.FileInfo fileInfo = new PostRequest.FileInfo();
        fileInfo.partName = partName;
        fileInfo.fileName = fileName;
        fileInfo.fileInputStream = is;
        this.fileInfos.add(fileInfo);
        return this;
    }

    public PostBuilder addFile(String partName, String fileName, File file) {
        PostRequest.FileInfo fileInfo = new PostRequest.FileInfo();
        fileInfo.partName = partName;
        fileInfo.fileName = fileName;
        fileInfo.file = file;
        this.fileInfos.add(fileInfo);
        return this;
    }

    public PostBuilder addFile(String partName, String fileName, String content) throws UnsupportedEncodingException {
        return this.addFile(partName, fileName, content, StandardCharsets.UTF_8.toString());
    }

    public PostBuilder addFile(String partName, String fileName, String content, String charsetName) throws UnsupportedEncodingException {
        return this.addFile(partName, fileName, content.getBytes(charsetName));
    }

    public PostBuilder addFile(String partName, String fileName, byte[] content, String charsetName) throws UnsupportedEncodingException {
        return this.addFile(partName, fileName, content);
    }
}

