/*
 * Decompiled with CFR 0.152.
 */
package io.itit.itf.okhttp;

import io.itit.itf.okhttp.FastHttpClientStat;
import io.itit.itf.okhttp.OkHttpRequest;
import io.itit.itf.okhttp.Response;
import io.itit.itf.okhttp.callback.Callback;
import java.io.IOException;
import okhttp3.Call;
import okhttp3.OkHttpClient;
import okhttp3.Request;

public class RequestCall {
    private OkHttpClient okHttpClient;
    private OkHttpRequest okHttpRequest;
    private Request request;
    private Call call;

    public RequestCall(OkHttpRequest request, OkHttpClient okHttpClient) {
        this.okHttpRequest = request;
        this.okHttpClient = okHttpClient;
    }

    public Call buildCall(Callback callback) {
        this.request = this.createRequest(callback);
        this.call = this.okHttpClient.newCall(this.request);
        return this.call;
    }

    private Request createRequest(Callback callback) {
        return this.okHttpRequest.createRequest(callback);
    }

    public Response execute() throws Exception {
        this.buildCall(null);
        try {
            Response rsp = new Response(this.call.execute());
            if (rsp.isSuccessful()) {
                FastHttpClientStat.onReqSuccess();
            } else {
                FastHttpClientStat.onReqFailure(this.call.request().url().toString(), null);
            }
            return rsp;
        }
        catch (Exception e) {
            FastHttpClientStat.onReqFailure(this.call.request().url().toString(), e);
            throw e;
        }
    }

    public void executeAsync(Callback callback) {
        this.buildCall(callback);
        this.execute(this, callback);
    }

    private void execute(RequestCall requestCall, Callback callback) {
        final Callback finalCallback = callback;
        final String id = requestCall.getOkHttpRequest().getId();
        requestCall.getCall().enqueue(new okhttp3.Callback(){

            public void onFailure(Call call, IOException e) {
                FastHttpClientStat.onReqFailure(call.request().url().toString(), e);
                if (finalCallback != null) {
                    finalCallback.onFailure(call, e, id);
                }
            }

            public void onResponse(Call call, okhttp3.Response response) {
                FastHttpClientStat.onReqSuccess();
                if (finalCallback != null) {
                    finalCallback.onResponse(call, new Response(response), id);
                }
            }
        });
    }

    public Call getCall() {
        return this.call;
    }

    public Request getRequest() {
        return this.request;
    }

    public OkHttpRequest getOkHttpRequest() {
        return this.okHttpRequest;
    }

    public void cancel() {
        if (this.call != null) {
            this.call.cancel();
        }
    }
}

