/*
 * Decompiled with CFR 0.152.
 */
package io.itit.itf.okhttp.interceptor;

import io.itit.itf.okhttp.interceptor.DownloadFileProgressListener;
import java.io.IOException;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.Buffer;
import okio.BufferedSource;
import okio.ForwardingSource;
import okio.Okio;
import okio.Source;

public abstract class DownloadFileInterceptor
implements Interceptor,
DownloadFileProgressListener {
    public Response intercept(Interceptor.Chain chain) throws IOException {
        Response rsp = chain.proceed(chain.request());
        return rsp.newBuilder().body((ResponseBody)new DownloadFileProgressResponseBody(rsp.body(), this)).build();
    }

    @Override
    public abstract void updateProgress(long var1, long var3, boolean var5);

    public static class DownloadFileProgressResponseBody
    extends ResponseBody {
        private final ResponseBody body;
        private final DownloadFileProgressListener progressListener;
        private BufferedSource bufferedSource;

        public DownloadFileProgressResponseBody(ResponseBody body, DownloadFileProgressListener progressListener) {
            this.body = body;
            this.progressListener = progressListener;
        }

        public MediaType contentType() {
            return this.body.contentType();
        }

        public long contentLength() {
            return this.body.contentLength();
        }

        public BufferedSource source() {
            if (this.bufferedSource == null) {
                this.bufferedSource = Okio.buffer((Source)this.source((Source)this.body.source()));
            }
            return this.bufferedSource;
        }

        private Source source(Source source) {
            return new ForwardingSource(source){
                long downloadLenth;
                {
                    super(arg0);
                    this.downloadLenth = 0L;
                }

                public long read(Buffer sink, long byteCount) throws IOException {
                    boolean isFinish;
                    long bytesRead = super.read(sink, byteCount);
                    boolean bl = isFinish = bytesRead == -1L;
                    if (!isFinish) {
                        this.downloadLenth += bytesRead;
                    }
                    progressListener.updateProgress(this.downloadLenth, body.contentLength(), isFinish);
                    return bytesRead;
                }
            };
        }
    }
}

