/*
 * Decompiled with CFR 0.152.
 */
package io.itit.itf.okhttp.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.Inflater;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IOUtil {
    private static Logger logger = LoggerFactory.getLogger(IOUtil.class);
    private static final int CACHE_SIZE = 512;

    public static byte[] compress(byte[] inputs) {
        if (inputs.length == 0) {
            return inputs;
        }
        Deflater deflater = new Deflater(1);
        deflater.setInput(inputs);
        deflater.finish();
        byte[] outputs = new byte[]{};
        try (ByteArrayOutputStream stream = new ByteArrayOutputStream(inputs.length);){
            byte[] bytes = new byte[512];
            while (!deflater.finished()) {
                int value = deflater.deflate(bytes);
                stream.write(bytes, 0, value);
            }
            outputs = stream.toByteArray();
            deflater.end();
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return outputs;
    }

    public static byte[] gzipCompress(byte[] inputs) throws Exception {
        if (inputs.length == 0) {
            return inputs;
        }
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            byte[] byArray;
            try (GZIPOutputStream is = new GZIPOutputStream(bos);){
                is.write(inputs);
                is.close();
                byArray = bos.toByteArray();
            }
            return byArray;
        }
    }

    public static byte[] gzipDecompress(byte[] inputs) throws Exception {
        if (inputs.length == 0) {
            return inputs;
        }
        try (ByteArrayInputStream bos = new ByteArrayInputStream(inputs);){
            byte[] byArray;
            try (GZIPInputStream in = new GZIPInputStream(bos);){
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                IOUtil.copy((InputStream)in, out);
                IOUtil.closeQuietly(in);
                IOUtil.closeQuietly(out);
                byArray = out.toByteArray();
            }
            return byArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] decompress(byte[] input) {
        if (input.length == 0) {
            return input;
        }
        Inflater decompressor = new Inflater();
        decompressor.setInput(input);
        ByteArrayOutputStream bos = new ByteArrayOutputStream(input.length);
        byte[] buf = new byte[512];
        try {
            while (!decompressor.finished()) {
                int count = decompressor.inflate(buf);
                bos.write(buf, 0, count);
            }
        }
        catch (DataFormatException e) {
            byte[] byArray = input;
            return byArray;
        }
        finally {
            try {
                decompressor.end();
                bos.close();
            }
            catch (IOException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        byte[] decompressedData = bos.toByteArray();
        return decompressedData;
    }

    public static void closeQuietly(OutputStream output) {
        try {
            if (output != null) {
                output.flush();
                output.close();
            }
        }
        catch (IOException ioe) {
            logger.error(ioe.getMessage(), (Throwable)ioe);
        }
    }

    public static void closeQuietly(InputStream input) {
        try {
            if (input != null) {
                input.close();
            }
        }
        catch (IOException ioe) {
            logger.error(ioe.getMessage(), (Throwable)ioe);
        }
    }

    public static long copy(InputStream input, OutputStream output) throws IOException {
        byte[] buffer = new byte[4096];
        long count = 0L;
        int n = 0;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
            count += (long)n;
        }
        return count;
    }

    public static String getContent(InputStream in) throws IOException {
        try (InputStreamReader isr = new InputStreamReader(in);){
            String string;
            try (BufferedReader br = new BufferedReader(isr);){
                StringBuilder sb = new StringBuilder();
                String s = null;
                while ((s = br.readLine()) != null) {
                    sb.append(s).append("\n");
                }
                string = sb.toString();
            }
            return string;
        }
    }

    public static List<String> getContentList(InputStream inStream) throws IOException {
        ArrayList<String> inputLines = new ArrayList<String>();
        BufferedReader br = new BufferedReader(new InputStreamReader(inStream));
        String line = null;
        while ((line = br.readLine()) != null) {
            inputLines.add(line);
        }
        return inputLines;
    }

    public static void unzip(File file, File destFolder) throws IOException {
        int BUFFER = 2048;
        BufferedOutputStream dest = null;
        BufferedInputStream is = null;
        ZipFile zipfile = new ZipFile(file);
        Enumeration<? extends ZipEntry> e = zipfile.entries();
        while (e.hasMoreElements()) {
            int count;
            ZipEntry entry = e.nextElement();
            if (entry.isDirectory()) {
                File f = new File(destFolder, entry.getName());
                f.mkdirs();
                continue;
            }
            InputStream iis = zipfile.getInputStream(entry);
            is = new BufferedInputStream(iis);
            byte[] data = new byte[2048];
            File theFile = new File(destFolder, entry.getName());
            FileOutputStream fos = new FileOutputStream(theFile);
            dest = new BufferedOutputStream(fos, 2048);
            while ((count = is.read(data, 0, 2048)) != -1) {
                dest.write(data, 0, count);
            }
            dest.flush();
            dest.close();
            is.close();
            iis.close();
        }
        zipfile.close();
    }

    public static void copyFile(File sourceFile, File destFile) throws Exception {
        IOUtil.copy((InputStream)new FileInputStream(sourceFile), new FileOutputStream(destFile));
    }

    public static void copyFile(String sourceURL, String destFilePath, BiConsumer<Long, Long> progress) throws Exception {
        File destFile = new File(destFilePath);
        URL url = new URL(sourceURL);
        FileOutputStream fos = new FileOutputStream(destFile);
        URLConnection connection = url.openConnection();
        long contentLength = connection.getContentLength();
        long currentLength = 0L;
        InputStream is = connection.getInputStream();
        byte[] buffer = new byte[4096];
        int n = 0;
        while (-1 != (n = is.read(buffer))) {
            currentLength += (long)n;
            fos.write(buffer, 0, n);
            if (progress == null) continue;
            progress.accept(contentLength, currentLength);
        }
        IOUtil.closeQuietly(is);
        IOUtil.closeQuietly(fos);
    }

    public static boolean deleteDirectory(File directory) {
        if (!directory.exists()) {
            return true;
        }
        Arrays.asList(directory.listFiles()).forEach(file -> {
            if (file.isDirectory()) {
                IOUtil.deleteDirectory(file);
            } else {
                file.delete();
            }
        });
        return directory.delete();
    }

    public static byte[] toByteArray(InputStream input) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        byte[] buf = new byte[1024];
        int n = input.read(buf);
        while (n != -1) {
            os.write(buf, 0, n);
            n = input.read(buf);
        }
        return os.toByteArray();
    }

    public static String toString(InputStream input) throws IOException {
        StringWriter sw = new StringWriter();
        IOUtil.copy(input, (Writer)sw);
        return sw.toString();
    }

    public static void copy(InputStream input, Writer output) throws IOException {
        InputStreamReader in = new InputStreamReader(input);
        IOUtil.copy(in, output);
    }

    public static int copy(Reader input, Writer output) throws IOException {
        long count = IOUtil.copyLarge(input, output);
        if (count > Integer.MAX_VALUE) {
            return -1;
        }
        return (int)count;
    }

    public static long copyLarge(Reader input, Writer output) throws IOException {
        char[] buffer = new char[4096];
        long count = 0L;
        int n = 0;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
            count += (long)n;
        }
        return count;
    }
}

