/*
 * Decompiled with CFR 0.152.
 */
package com.github.jasync.sql.db.mysql.binary.encoder;

import com.github.jasync.sql.db.mysql.binary.encoder.BinaryEncoder;
import com.github.jasync.sql.db.mysql.column.ColumnTypes;
import io.netty.buffer.ByteBuf;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.joda.time.LocalTime;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/github/jasync/sql/db/mysql/binary/encoder/LocalTimeEncoder;", "Lcom/github/jasync/sql/db/mysql/binary/encoder/BinaryEncoder;", "()V", "encode", "", "value", "", "buffer", "Lio/netty/buffer/ByteBuf;", "encodesTo", "", "jasync-mysql"})
public final class LocalTimeEncoder
implements BinaryEncoder {
    public static final LocalTimeEncoder INSTANCE;

    @Override
    public void encode(@NotNull Object value, @NotNull ByteBuf buffer) {
        boolean hasMillis;
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        Intrinsics.checkParameterIsNotNull((Object)buffer, (String)"buffer");
        LocalTime time = (LocalTime)value;
        boolean bl = hasMillis = time.getMillisOfSecond() != 0;
        if (hasMillis) {
            buffer.writeByte(12);
        } else {
            buffer.writeByte(8);
        }
        if (time.getMillisOfDay() > 0) {
            buffer.writeByte(0);
        } else {
            buffer.writeByte(1);
        }
        buffer.writeInt(0);
        buffer.writeByte(time.getHourOfDay());
        buffer.writeByte(time.getMinuteOfHour());
        buffer.writeByte(time.getSecondOfMinute());
        if (hasMillis) {
            buffer.writeInt(time.getMillisOfSecond() * 1000);
        }
    }

    @Override
    public int encodesTo() {
        return ColumnTypes.INSTANCE.getFIELD_TYPE_TIME();
    }

    private LocalTimeEncoder() {
    }

    static {
        LocalTimeEncoder localTimeEncoder;
        INSTANCE = localTimeEncoder = new LocalTimeEncoder();
    }
}

